/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat.computer;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.compat.computer.ComputerMethod;
import it.zerono.mods.zerocore.lib.compat.computer.ComputerPeripheral;
import it.zerono.mods.zerocore.lib.compat.computer.IComputerMethodHandler;
import it.zerono.mods.zerocore.lib.compat.computer.LuaHelper;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public abstract class MultiblockComputerPeripheral<Controller extends IMultiblockController<Controller>, Part extends AbstractMultiblockPart<Controller>>
extends ComputerPeripheral<MultiblockComputerPeripheral<Controller, Part>> {
    public MultiblockComputerPeripheral(Part part) {
        super((BlockEntity)part);
    }

    public Part getMultiblockPart() {
        return (Part)((AbstractMultiblockPart)this.getTileEntity());
    }

    protected void executeOnController(Consumer<Controller> code) {
        ((AbstractMultiblockPart)this.getMultiblockPart()).executeOnController(code);
    }

    protected Object evalOnControllerValue(Function<Controller, Object> code) {
        return ((AbstractMultiblockPart)this.getMultiblockPart()).evalOnController(code, (Object[])ComputerMethod.EMPTY_RESULT);
    }

    protected Object[] evalOnControllerArray(Function<Controller, Object[]> code) {
        return ((AbstractMultiblockPart)this.getMultiblockPart()).evalOnController(code, (Object[])ComputerMethod.EMPTY_RESULT);
    }

    @Override
    public void populateMethods(Consumer<@NotNull ComputerMethod<MultiblockComputerPeripheral<Controller, Part>>> methodConsumer) {
        methodConsumer.accept(new ComputerMethod<MultiblockComputerPeripheral<Controller, AbstractMultiblockPart>>("mbIsConnected", this.wrapPartValue(AbstractMultiblockPart::isConnected)));
        methodConsumer.accept(new ComputerMethod<MultiblockComputerPeripheral<Controller, AbstractMultiblockPart>>("mbIsAssembled", this.wrapPartValue(AbstractMultiblockPart::isMachineAssembled)));
        methodConsumer.accept(new ComputerMethod<MultiblockComputerPeripheral<Controller, AbstractMultiblockPart>>("mbIsDisassembled", this.wrapPartValue(AbstractMultiblockPart::isMachineDisassembled)));
        methodConsumer.accept(new ComputerMethod<MultiblockComputerPeripheral<Controller, AbstractMultiblockPart>>("mbIsPaused", this.wrapPartValue(AbstractMultiblockPart::isMachinePaused)));
        methodConsumer.accept(new ComputerMethod<MultiblockComputerPeripheral<Controller, AbstractMultiblockPart>>("mbGetMultiblockControllerTypeName", this.wrapPartValue((Part p) -> p.getControllerType().getName())));
        methodConsumer.accept(new ComputerMethod<MultiblockComputerPeripheral<IMultiblockController, Part>>("mbGetMinimumCoordinate", this.wrapControllerValue((Controller c) -> LuaHelper.blockPosToArray(c.getBoundingBox().getMin()))));
        methodConsumer.accept(new ComputerMethod<MultiblockComputerPeripheral<IMultiblockController, Part>>("mbGetMaximumCoordinate", this.wrapControllerValue((Controller c) -> LuaHelper.blockPosToArray(c.getBoundingBox().getMax()))));
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && other instanceof MultiblockComputerPeripheral && CodeHelper.optionalMap(((AbstractMultiblockPart)this.getMultiblockPart()).getMultiblockController(), ((AbstractMultiblockPart)((MultiblockComputerPeripheral)other).getMultiblockPart()).getMultiblockController(), IMultiblockController::isSameController).orElse(false) != false;
    }

    protected IComputerMethodHandler<MultiblockComputerPeripheral<Controller, Part>> wrapPartValue(Function<Part, Object> code) {
        return (peripheral, arguments) -> MultiblockComputerPeripheral.luaValueResult(code.apply(peripheral.getMultiblockPart()));
    }

    protected IComputerMethodHandler<MultiblockComputerPeripheral<Controller, Part>> wrapPartValue(BiFunction<Part, Object[], Object> code) {
        return (peripheral, arguments) -> MultiblockComputerPeripheral.luaValueResult(code.apply(peripheral.getMultiblockPart(), arguments));
    }

    protected IComputerMethodHandler<MultiblockComputerPeripheral<Controller, Part>> wrapPartArray(Function<Part, Object[]> code) {
        return (peripheral, arguments) -> MultiblockComputerPeripheral.luaArrayResult((Object[])code.apply(peripheral.getMultiblockPart()));
    }

    protected IComputerMethodHandler<MultiblockComputerPeripheral<Controller, Part>> wrapPartArray(BiFunction<Part, Object[], Object[]> code) {
        return (peripheral, arguments) -> MultiblockComputerPeripheral.luaArrayResult((Object[])code.apply(peripheral.getMultiblockPart(), arguments));
    }

    protected IComputerMethodHandler<MultiblockComputerPeripheral<Controller, Part>> wrapControllerValue(Function<Controller, Object> code) {
        return (peripheral, arguments) -> MultiblockComputerPeripheral.luaValueResult(peripheral.evalOnControllerValue(code));
    }

    protected IComputerMethodHandler<MultiblockComputerPeripheral<Controller, Part>> wrapControllerValue(BiFunction<Controller, Object[], Object> code) {
        return (peripheral, arguments) -> MultiblockComputerPeripheral.luaValueResult(peripheral.evalOnControllerValue(c -> code.apply(c, arguments)));
    }

    protected IComputerMethodHandler<MultiblockComputerPeripheral<Controller, Part>> wrapControllerArray(Function<Controller, Object[]> code) {
        return (peripheral, arguments) -> MultiblockComputerPeripheral.luaValueResult(peripheral.evalOnControllerArray(code));
    }

    protected IComputerMethodHandler<MultiblockComputerPeripheral<Controller, Part>> wrapControllerArray(BiFunction<Controller, Object[], Object[]> code) {
        return (peripheral, arguments) -> MultiblockComputerPeripheral.luaValueResult(peripheral.evalOnControllerArray(c -> (Object[])code.apply(c, arguments)));
    }

    protected IComputerMethodHandler<MultiblockComputerPeripheral<Controller, Part>> wrapControllerAction(Consumer<Controller> code) {
        return (peripheral, arguments) -> {
            peripheral.executeOnController(code);
            return MultiblockComputerPeripheral.luaValueResult(null);
        };
    }

    protected IComputerMethodHandler<MultiblockComputerPeripheral<Controller, Part>> wrapControllerAction(BiConsumer<Controller, Object[]> code) {
        return (peripheral, arguments) -> {
            peripheral.executeOnController(c -> code.accept(c, arguments));
            return MultiblockComputerPeripheral.luaValueResult(null);
        };
    }
}

