/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.compat.computer;

import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.compat.computer.ComputerPeripheral;
import it.zerono.mods.zerocore.lib.compat.computer.IComputerMethodHandler;
import it.zerono.mods.zerocore.lib.compat.computer.LuaHelper;
import net.neoforged.fml.LogicalSide;

public class ComputerMethod<P extends ComputerPeripheral<P>> {
    public static final Object[] EMPTY_RESULT = new Object[0];
    private static final ComputerMethod EMPTY_METHOD = new ComputerMethod<ComputerPeripheral>("42emptyMethod", (p, args) -> EMPTY_RESULT, 0, false);
    private final String _name;
    private final IComputerMethodHandler<P> _handler;
    private final int _minArgumentsCount;
    private final boolean _runOnServerThread;

    public ComputerMethod(String name, IComputerMethodHandler<P> handler) {
        this(name, handler, 0, false);
    }

    public ComputerMethod(String name, IComputerMethodHandler<P> handler, int minArgumentsCount) {
        this(name, handler, minArgumentsCount, false);
    }

    public ComputerMethod(String name, IComputerMethodHandler<P> handler, int minArgumentsCount, boolean runOnServerThread) {
        this._name = name;
        this._handler = handler;
        this._minArgumentsCount = minArgumentsCount;
        this._runOnServerThread = runOnServerThread;
    }

    public String getName() {
        return this._name;
    }

    public int getMinArgumentsCount() {
        return this._minArgumentsCount;
    }

    public Object[] invoke(P peripheral, Object[] arguments) {
        LuaHelper.validateArgsCount(arguments, this._minArgumentsCount);
        if (this._runOnServerThread) {
            CodeHelper.enqueueTask(LogicalSide.SERVER, () -> {
                try {
                    this._handler.execute(peripheral, arguments);
                }
                catch (Exception ex) {
                    Log.LOGGER.error(Log.COMPAT_COMPUTERS, "Exception raised while running computer method {} on server thread : {}", (Object)this.getName(), (Object)ex.getMessage());
                }
            });
            return EMPTY_RESULT;
        }
        Object[] result = this._handler.execute(peripheral, arguments);
        return null != result ? result : EMPTY_RESULT;
    }

    public static <P extends ComputerPeripheral<P>> ComputerMethod<P> getEmptyMethod() {
        return EMPTY_METHOD;
    }
}

