/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class SpiralParticle
extends Particle {
    protected float _angle = 0.0f;
    protected final double _centerX;
    protected final double _centerZ;
    protected final double _radius;

    protected SpiralParticle(ClientLevel world, double centerX, double centerY, double centerZ, double radius, int lifeInTicks) {
        super(world, centerX + radius * 1.0, centerY, centerZ + radius * 0.0);
        this._centerX = centerX;
        this._centerZ = centerZ;
        this._radius = radius;
        this.setLifetime(lifeInTicks);
    }

    public void tick() {
        float f;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (++this.age >= this.getLifetime()) {
            this.remove();
        }
        this._angle += 10.0f;
        if (f >= 360.0f) {
            this._angle = 0.0f;
        }
        float radiants = (float)((double)this._angle * Math.PI / 180.0);
        double newX = this._centerX + this._radius * (double)Mth.cos((float)radiants);
        double newZ = this._centerZ + this._radius * (double)Mth.sin((float)radiants);
        this.xd = newX - this.x;
        this.zd = newZ - this.z;
        this.yd = 0.01;
        this.move(this.xd, this.yd, this.zd);
    }
}

