/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import com.google.common.collect.Lists;
import it.zerono.mods.zerocore.lib.client.gui.IWindow;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.Theme;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractTextualControl;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class TextInput
extends AbstractTextualControl {
    public final IEvent<BiConsumer<TextInput, Boolean>> Changed;
    private static final Predicate<Character> DEFAULT_CHAR_FILTER = character -> true;
    private StringBuilder _textBuffer;
    private String _textCache;
    private String _paintingSuffix = "";
    private String _paintingCache;
    private int _displayCharIndex;
    private int _caretCharIndex;
    private long _caretBlinkTimer;
    private boolean _editable = true;
    private Predicate<Character> _charFilter = DEFAULT_CHAR_FILTER;
    private List<Function<String, Optional<String>>> _constraints;
    private int _maxLength = 0;

    public TextInput(ModContainerScreen<? extends ModContainer> gui, String name) {
        this(gui, name, "");
    }

    public TextInput(ModContainerScreen<? extends ModContainer> gui, String name, Component text) {
        this(gui, name, text.getString());
    }

    public TextInput(ModContainerScreen<? extends ModContainer> gui, String name, String text) {
        super(gui, name, text);
        this.Changed = new Event<BiConsumer<TextInput, Boolean>>();
        this.setPadding(2, 2, 2, 2);
        this.setHorizontalAlignment(HorizontalAlignment.Left);
        this.setVerticalAlignment(VerticalAlignment.Center);
        this.setEditable(true);
        this.caretMoved();
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
    }

    public void setDisplaySuffix(@Nullable String suffix) {
        this._paintingSuffix = suffix;
        this._paintingCache = null;
    }

    public void setFilter(Predicate<Character> filter) {
        this._charFilter = filter;
    }

    public void addConstraint(Function<String, Optional<String>> constraint) {
        if (null == this._constraints) {
            this._constraints = Lists.newArrayList();
        }
        this._constraints.add(constraint);
    }

    public void removeFilter() {
        this._charFilter = null;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public void setMaxLength(int length) {
        this._maxLength = Math.max(0, length);
        if (0 != this._maxLength && this._textBuffer.length() > this._maxLength) {
            this._textBuffer = new StringBuilder(this._textBuffer.substring(0, this._maxLength));
        }
    }

    public int intValue() throws NumberFormatException {
        return Integer.parseInt(this.getText());
    }

    public long longValue() throws NumberFormatException {
        return Long.parseLong(this.getText());
    }

    public float floatValue() throws NumberFormatException {
        return Float.parseFloat(this.getText());
    }

    public double doubleValue() throws NumberFormatException {
        return Double.parseDouble(this.getText());
    }

    @Override
    public void onWindowClosed() {
        super.onWindowClosed();
        this.Changed.unsubscribeAll();
    }

    @Override
    public String getText() {
        if (null == this._textCache) {
            this._textCache = this._textBuffer.toString();
        }
        return this._textCache;
    }

    @Override
    public void setText(String text) {
        this._textBuffer = text.chars().mapToObj(i -> Character.valueOf((char)i)).filter(this.getCharFilter()).limit(this._maxLength > 0 ? (long)this._maxLength : (long)text.length()).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append);
        this._caretCharIndex = this._textBuffer.length();
        if (this._displayCharIndex >= this._caretCharIndex) {
            this._displayCharIndex = this._caretCharIndex - 1;
            if (this._displayCharIndex < 0) {
                this._displayCharIndex = 0;
            }
        }
        this.textChanged(false);
    }

    @Override
    public boolean onCharTyped(IWindow wnd, char typedChar, int keyCode) {
        if (!this.isEditable() || '\u0000' == typedChar) {
            return false;
        }
        if ((0 == this._maxLength || this._maxLength > 0 && this._textBuffer.length() < this._maxLength) && this.getCharFilter().test(Character.valueOf(typedChar))) {
            this._textBuffer.insert(this._caretCharIndex, typedChar);
            ++this._caretCharIndex;
            this.textChanged(true);
            this.caretMoved();
        }
        return true;
    }

    @Override
    public boolean onKeyPressed(IWindow wnd, int keyCode, int scanCode, int modifiers) {
        if (!this.isEditable()) {
            return false;
        }
        if (259 == keyCode) {
            if (this._textBuffer.length() > 0 && this._caretCharIndex > 0) {
                this._textBuffer.deleteCharAt(--this._caretCharIndex);
                if (this._displayCharIndex > 0) {
                    --this._displayCharIndex;
                }
                this.textChanged(true);
                this.caretMoved();
            }
        } else if (261 == keyCode) {
            if (this._caretCharIndex < this._textBuffer.length()) {
                this._textBuffer.deleteCharAt(this._caretCharIndex);
                this._caretCharIndex = Math.min(this._caretCharIndex, this._textBuffer.length());
                if (this._displayCharIndex > 0) {
                    --this._displayCharIndex;
                }
                this.textChanged(true);
                this.caretMoved();
            }
        } else if (268 == keyCode) {
            this._caretCharIndex = 0;
            this.caretMoved();
        } else if (269 == keyCode) {
            this._caretCharIndex = this._textBuffer.length();
            this.caretMoved();
        } else if (263 == keyCode) {
            if (this._caretCharIndex > 0) {
                --this._caretCharIndex;
                this.caretMoved();
            }
        } else if (262 == keyCode) {
            if (this._caretCharIndex < this._textBuffer.length()) {
                ++this._caretCharIndex;
                this.caretMoved();
            }
        } else if (257 == keyCode || 335 == keyCode || 256 == keyCode) {
            return false;
        }
        return super.onKeyPressed(wnd, keyCode, scanCode, modifiers);
    }

    @Override
    public void onPaintBackground(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        Theme theme = this.getTheme();
        this.paint3DSunkenBox(gfx, 0, 0, this.getBounds().Width, this.getBounds().Height, theme.TEXTFIELD_NORMAL_3D_GRADIENT_LIGHT, theme.TEXTFIELD_NORMAL_3D_GRADIENT_DARK, theme.TEXTFIELD_NORMAL_3D_BORDER_LIGHT, theme.TEXTFIELD_NORMAL_3D_BORDER_DARK);
    }

    @Override
    public void onPaint(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        this.ensureVisible();
        this.paintTextLine(gfx, this.getTextForPainting(), 0, 0, this.getTextAreaWidth(), this.getTextAreaHeight(), this.getEnabled() ? this.getColor() : this.getDisabledColor());
        if (this.hasFocus()) {
            this.paintCaret(gfx);
        }
    }

    @Override
    protected StringBuilder toStringBuilder() {
        return super.toStringBuilder().append("; buffer:[").append((CharSequence)this._textBuffer).append("]; textCache:[").append(null != this._textCache ? this._textCache : "").append("]; paintCache:[").append(null != this._paintingCache ? this._paintingCache : "").append("]; maxLen:").append(this._maxLength).append("; editable:").append(this._editable);
    }

    private void textChanged(boolean changedByTyping) {
        this._textCache = null;
        this.resetPaintingCache();
        if (changedByTyping) {
            this.applyConstraints();
        }
        if (null != this.Changed) {
            this.Changed.raise(c -> c.accept(this, changedByTyping));
        }
    }

    private void applyConstraints() {
        String text;
        if (null == this._constraints) {
            return;
        }
        String current = text = this.getText();
        for (Function<String, Optional<String>> constraint : this._constraints) {
            current = constraint.apply(current).orElse(current);
        }
        if (!text.equals(current)) {
            this.setText(current);
        }
    }

    private void resetPaintingCache() {
        this._paintingCache = null;
    }

    private void caretMoved() {
        this._caretBlinkTimer = System.currentTimeMillis();
    }

    protected String getTextForPainting() {
        if (null == this._paintingCache) {
            this._paintingCache = this.suffixedText().substring(this._displayCharIndex);
        }
        return this._paintingCache;
    }

    private String suffixedText() {
        return null != this._paintingSuffix ? this.getText() + this._paintingSuffix : this.getText();
    }

    private void ensureVisible() {
        if (this._caretCharIndex < this._displayCharIndex) {
            this._displayCharIndex = this._caretCharIndex;
        } else {
            Font font = this.getFontRender();
            String text = this.getText();
            int textAreaWidth = this.getTextAreaWidth();
            int visibleTextWidth = this.getLineWidth(text.substring(this._displayCharIndex, this._caretCharIndex));
            while (visibleTextWidth > textAreaWidth) {
                visibleTextWidth -= font.width(text.substring(this._displayCharIndex, this._displayCharIndex + 1));
                ++this._displayCharIndex;
            }
        }
        this.resetPaintingCache();
    }

    private void paintCaret(GuiGraphics gfx) {
        if ((this._caretBlinkTimer - System.currentTimeMillis()) / 500L % 2L != 0L) {
            return;
        }
        int x = Math.max(1, this.getLineWidth(this.getText().substring(this._displayCharIndex, this._caretCharIndex)));
        this.paintSolidRect(gfx, x, 2, x + 1, 2 + this.getTextAreaHeight() - 1, this.getTheme().TEXTFIELD_CARET);
    }

    private Predicate<Character> getCharFilter() {
        return null != this._charFilter ? this._charFilter : DEFAULT_CHAR_FILTER;
    }
}

