/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractControl;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import java.util.Objects;
import java.util.function.Function;
import joptsimple.internal.Strings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTextualControl
extends AbstractControl {
    private final Font _fontRender;
    private String _text;
    private HorizontalAlignment _horizontalAlignment;
    private VerticalAlignment _verticalAlignment;
    @Nullable
    private Colour _enabledColor;
    @Nullable
    private Colour _disabledColor;

    public AbstractTextualControl(ModContainerScreen<? extends ModContainer> gui, String name, String text) {
        super(gui, name);
        this._fontRender = Minecraft.getInstance().font;
        this.setHorizontalAlignment(HorizontalAlignment.Left);
        this.setVerticalAlignment(VerticalAlignment.Center);
        this.setText(text);
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this._text = text;
    }

    public void setText(String formatString, Object ... parameters) {
        this.setText(String.format(formatString, parameters));
    }

    public void setText(Component text) {
        this.setText(text.getString());
    }

    public <V> void bindText(IBindableData<V> bindableValue, Function<V, String> stringFactory) {
        bindableValue.bind(v -> this.setText(Objects.requireNonNull((String)stringFactory.apply(v))));
    }

    public Colour getColor() {
        return null != this._enabledColor ? this._enabledColor : this.getTheme().TEXT_ENABLED_COLOR;
    }

    public void setColor(Colour color) {
        this._enabledColor = color;
    }

    public Colour getDisabledColor() {
        return null != this._disabledColor ? this._disabledColor : this.getTheme().TEXT_DISABLED_COLOR;
    }

    public void setDisabledColor(Colour color) {
        this._disabledColor = color;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this._horizontalAlignment;
    }

    public void setHorizontalAlignment(HorizontalAlignment alignment) {
        this._horizontalAlignment = alignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this._verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment alignment) {
        this._verticalAlignment = alignment;
    }

    public int getTextWidth() {
        return this.getLineWidth(this.getText());
    }

    public int getTextHeight() {
        Objects.requireNonNull(this.getFontRender());
        return 9 - 1;
    }

    protected void paintTextLine(GuiGraphics gfx, String line, int x, int y, int lineAreaWidth, int lineAreaHeight, Colour color) {
        Font font = this.getFontRender();
        line = font.plainSubstrByWidth(line, lineAreaWidth);
        if (line.isEmpty()) {
            return;
        }
        this.paintText(gfx, font, color, line, this.getHorizontalAlignment().align(x, this.getLineWidth(line), lineAreaWidth) + this.getPadding().getLeft() + this.getTextOffsetX(), this.getVerticalAlignment().align(y, this.getLineHeight(line), lineAreaHeight) + this.getPadding().getTop() + this.getTextOffsetY());
    }

    protected void paintText(GuiGraphics gfx, Font font, Colour colour, String text, int x, int y) {
        if (!Strings.isNullOrEmpty((String)text)) {
            Point screenXY = this.controlToScreen(x, y);
            gfx.drawString(font, text, screenXY.X, screenXY.Y, colour.toARGB(), false);
        }
    }

    protected Font getFontRender() {
        return this._fontRender;
    }

    protected int getTextOffsetX() {
        return 0;
    }

    protected int getTextOffsetY() {
        return 0;
    }

    protected int getTextAreaWidth() {
        return Math.max(0, this.getBounds().Width - (this.getPadding().getHorizontal() + this.getTextOffsetX()));
    }

    protected int getTextAreaHeight() {
        return Math.max(0, this.getBounds().Height - (this.getPadding().getVertical() + this.getTextOffsetY()));
    }

    protected int getLineWidth(String line) {
        return this.getFontRender().width(line);
    }

    protected int getLineHeight(String line) {
        return this.getTextHeight();
    }

    @Override
    public void onPaint(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        this.paintTextLine(gfx, this.getText(), 0, 0, this.getTextAreaWidth(), this.getTextAreaHeight(), this.getEnabled() ? this.getColor() : this.getDisabledColor());
    }

    @Override
    protected StringBuilder toStringBuilder() {
        return super.toStringBuilder().append("; text:[").append(this._text).append("]");
    }
}

