/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.block;

import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.ITileCommandHandler;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.PacketFlow;

@FunctionalInterface
public interface ITileCommandDispatcher {
    public void dispatch(PacketFlow var1, String var2, CompoundTag var3);

    public static interface Builder<T extends AbstractModBlockEntity> {
        public Builder<T> addHandler(String var1, ITileCommandHandler<T> var2);

        default public Builder<T> addHandler(String name, BiConsumer<T, PacketFlow> handler) {
            return this.addHandler(name, (T tile, PacketFlow source, CompoundTag parameters) -> handler.accept(tile, source));
        }

        default public Builder<T> addServerHandler(String name, BiConsumer<T, CompoundTag> handler) {
            return this.addHandler(name, (T tile, PacketFlow flow, CompoundTag parameters) -> {
                if (PacketFlow.SERVERBOUND == flow) {
                    handler.accept(tile, parameters);
                }
            });
        }

        default public Builder<T> addServerHandler(String name, Consumer<T> handler) {
            return this.addHandler(name, (T tile, PacketFlow flow, CompoundTag parameters) -> {
                if (PacketFlow.SERVERBOUND == flow) {
                    handler.accept(tile);
                }
            });
        }

        default public Builder<T> addClientHandler(String name, BiConsumer<T, CompoundTag> handler) {
            return this.addHandler(name, (T tile, PacketFlow flow, CompoundTag parameters) -> {
                if (PacketFlow.CLIENTBOUND == flow) {
                    handler.accept(tile, parameters);
                }
            });
        }

        default public Builder<T> addClientHandler(String name, Consumer<T> handler) {
            return this.addHandler(name, (T tile, PacketFlow flow, CompoundTag parameters) -> {
                if (PacketFlow.CLIENTBOUND == flow) {
                    handler.accept(tile);
                }
            });
        }

        public ITileCommandDispatcher build(T var1);
    }
}

