/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.item;

import com.mamailes.merrymaking.init.MMItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class MintBottleItem
extends Item {
    public MintBottleItem(Item.Properties p_40648_) {
        super(p_40648_);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        List list = level.getEntitiesOfClass(AreaEffectCloud.class, player.getBoundingBox().inflate(2.0), p_40650_ -> p_40650_ != null && p_40650_.isAlive() && p_40650_.getOwner() instanceof EnderDragon);
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult hitresult = MintBottleItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hitresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (hitresult.getType() == HitResult.Type.BLOCK) {
            BlockPos blockpos = hitresult.getBlockPos();
            if (!level.mayInteract(player, blockpos)) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            if (level.getFluidState(blockpos).is(FluidTags.WATER)) {
                level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, blockpos);
                return InteractionResultHolder.sidedSuccess((Object)this.turnBottleIntoItem(itemstack, player, new ItemStack((ItemLike)MMItems.PEPPERMINT_EXTRACT.get())), (boolean)level.isClientSide());
            }
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    protected ItemStack turnBottleIntoItem(ItemStack stack, Player player, ItemStack p_40654_) {
        stack.shrink(1);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (p_40654_.isEmpty()) {
            return stack;
        }
        if (!player.getInventory().add(stack)) {
            player.drop(stack, false);
        }
        return ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)p_40654_);
    }
}

