/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.init;

import com.google.common.collect.ImmutableList;
import com.mamailes.merrymaking.MerryMaking;
import com.mamailes.merrymaking.init.MMBlocks;
import com.mamailes.merrymaking.init.MMConfiguredFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;

public class MMPlacedFeatures {
    public static final ResourceKey<PlacedFeature> HOLLY_PLACEMENT = MMPlacedFeatures.registerKey("holly_placement");
    public static final ResourceKey<PlacedFeature> SMALL_SPRUCE_PLACEMENT = MMPlacedFeatures.registerKey("small_spruce_placement");

    public static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)MerryMaking.prefix(name));
    }

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter features = context.lookup(Registries.CONFIGURED_FEATURE);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        context.register(HOLLY_PLACEMENT, (Object)new PlacedFeature((Holder)features.getOrThrow(MMConfiguredFeatures.HOLLY_TREE), MMPlacedFeatures.ModTreeCheckArea(PlacementUtils.countExtra((int)1, (float)0.1f, (int)1), ((Block)MMBlocks.HOLLY_SAPLING.get()).defaultBlockState())));
        context.register(SMALL_SPRUCE_PLACEMENT, (Object)new PlacedFeature((Holder)features.getOrThrow(MMConfiguredFeatures.SMALL_SPRUCE_TREE), (List)ImmutableList.builder().add((Object[])new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, CountPlacement.of((int)5), InSquarePlacement.spread(), RarityFilter.onAverageOnceEvery((int)20), BiomeFilter.biome()}).build()));
    }

    private static List<PlacementModifier> ModTreeCheckArea(PlacementModifier count, BlockState sapling) {
        return ImmutableList.of((Object)count, (Object)InSquarePlacement.spread(), (Object)SurfaceWaterDepthFilter.forMaxDepth((int)0), (Object)PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, (Object)PlacementUtils.filteredByBlockSurvival((Block)sapling.getBlock()), (Object)BiomeFilter.biome());
    }
}

