/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.block.deco.lights;

import com.mamailes.merrymaking.block.deco.base.HorizontalDecoBlock;
import com.mamailes.merrymaking.util.MMHShapes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConnectingGarland
extends HorizontalDecoBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.create((String)"type", Type.class);
    public final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();

    public ConnectingGarland(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(TYPE, (Comparable)((Object)Type.DEFAULT))).setValue((Property)DIRECTION, (Comparable)Direction.NORTH));
    }

    private VoxelShape getShape(BlockState state) {
        return this.SHAPES.computeIfAbsent(state, state1 -> {
            VoxelShape TOP = Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
            VoxelShape[] DEFAULT_BASE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0), Direction.SOUTH));
            VoxelShape[] LEFT_INVERTED_BASE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)8.0, (double)10.0, (double)6.0, (double)16.0, (double)16.0), Direction.SOUTH));
            VoxelShape[] RIGHT_INVERTED_BASE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)10.0, (double)8.0, (double)10.0, (double)16.0, (double)16.0, (double)16.0), Direction.SOUTH));
            VoxelShape[] LEFT_CORNER_BASE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)0.0, (double)8.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0), Direction.SOUTH));
            VoxelShape[] RIGHT_CORNER_BASE = MMHShapes.getRotatedShapes(MMHShapes.rotate(Block.box((double)10.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Direction.SOUTH));
            Type type = (Type)((Object)((Object)state1.getValue(TYPE)));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(TOP);
            switch (type.ordinal()) {
                case 0: {
                    shapes.add(DEFAULT_BASE[((Direction)state.getValue((Property)DIRECTION)).get2DDataValue()]);
                    break;
                }
                case 1: {
                    shapes.add(DEFAULT_BASE[((Direction)state.getValue((Property)DIRECTION)).get2DDataValue()]);
                    shapes.add(LEFT_CORNER_BASE[((Direction)state.getValue((Property)DIRECTION)).get2DDataValue()]);
                    break;
                }
                case 2: {
                    shapes.add(DEFAULT_BASE[((Direction)state.getValue((Property)DIRECTION)).get2DDataValue()]);
                    shapes.add(RIGHT_CORNER_BASE[((Direction)state.getValue((Property)DIRECTION)).get2DDataValue()]);
                    break;
                }
                case 3: {
                    shapes.add(LEFT_INVERTED_BASE[((Direction)state.getValue((Property)DIRECTION)).get2DDataValue()]);
                    break;
                }
                case 4: {
                    shapes.add(RIGHT_INVERTED_BASE[((Direction)state.getValue((Property)DIRECTION)).get2DDataValue()]);
                }
            }
            return MMHShapes.combineShapes(shapes);
        });
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return this.getShape(state);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.getShape(state);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getDecorationState(super.getStateForPlacement(context), (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.getDecorationState(state, level, pos);
    }

    private BlockState getDecorationState(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockState backState;
        Direction direction = (Direction)state.getValue((Property)DIRECTION);
        BlockState frontState = level.getBlockState(pos.relative(direction.getOpposite()));
        if (frontState.getBlock() instanceof ConnectingGarland) {
            if (frontState.getValue((Property)DIRECTION) == direction.getClockWise()) {
                return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.RIGHT_CORNER));
            }
            if (frontState.getValue((Property)DIRECTION) == direction.getCounterClockWise()) {
                return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.LEFT_CORNER));
            }
        }
        if ((backState = level.getBlockState(pos.relative(direction))).getBlock() instanceof ConnectingGarland) {
            BlockState rightState;
            BlockState leftState;
            if (!(backState.getValue((Property)DIRECTION) != direction.getClockWise() || (leftState = level.getBlockState(pos.relative(direction.getCounterClockWise()))).getBlock() instanceof ConnectingGarland && leftState.getValue((Property)DIRECTION) != direction.getOpposite())) {
                return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.LEFT_CORNER_INVERTED));
            }
            if (!(backState.getValue((Property)DIRECTION) != direction.getCounterClockWise() || (rightState = level.getBlockState(pos.relative(direction.getClockWise()))).getBlock() instanceof ConnectingGarland && rightState.getValue((Property)DIRECTION) != direction.getOpposite())) {
                return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.RIGHT_CORNER_INVERTED));
            }
        }
        return (BlockState)state.setValue(TYPE, (Comparable)((Object)Type.DEFAULT));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TYPE});
    }

    public static enum Type implements StringRepresentable
    {
        DEFAULT("default"),
        LEFT_CORNER("left_corner"),
        RIGHT_CORNER("right_corner"),
        LEFT_CORNER_INVERTED("left_corner_inverted"),
        RIGHT_CORNER_INVERTED("right_corner_inverted");

        private String id;

        private Type(String id) {
            this.id = id;
        }

        public String toString() {
            return this.getSerializedName();
        }

        public String getSerializedName() {
            return this.id;
        }
    }
}

