/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement.structure;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.config.ServerConfiguration;
import com.ldtteam.structurize.placement.structure.AbstractStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class CreativeStructureHandler
extends AbstractStructureHandler {
    public boolean fancyPlacement;

    public CreativeStructureHandler(Level world, BlockPos pos, Blueprint blueprint, RotationMirror rotMir, boolean fancyPlacement) {
        super(world, pos, blueprint, rotMir);
        this.fancyPlacement = fancyPlacement;
    }

    public CreativeStructureHandler(Level world, BlockPos pos, Future<Blueprint> blueprint, RotationMirror rotMir, boolean fancyPlacement) {
        super(world, pos, blueprint, rotMir);
        this.fancyPlacement = fancyPlacement;
    }

    @Override
    @Nullable
    public IItemHandler getInventory() {
        return null;
    }

    @Override
    public void triggerEntitySuccess(BlockPos pos, List<ItemStack> requiredRes, boolean placement) {
    }

    @Override
    public int getMaxBlocksCheckedPerCall() {
        return (Integer)((ServerConfiguration)Structurize.getConfig().getServer()).maxOperationsPerTick.get();
    }

    @Override
    public boolean isStackFree(@Nullable ItemStack stack) {
        return true;
    }

    @Override
    public boolean allowReplace() {
        return true;
    }

    @Override
    public ItemStack getHeldItem() {
        return ItemStack.EMPTY;
    }

    @Override
    public boolean replaceWithSolidBlock(BlockState blockState) {
        return !BlockUtils.isGoodFloorBlock(blockState);
    }

    @Override
    public boolean fancyPlacement() {
        return this.fancyPlacement;
    }

    @Override
    public boolean isCreative() {
        return true;
    }

    @Override
    public int getStepsPerCall() {
        return (Integer)((ServerConfiguration)Structurize.getConfig().getServer()).maxOperationsPerTick.get();
    }

    @Override
    public boolean shouldBlocksBeConsideredEqual(BlockState state, BlockState state1) {
        return false;
    }

    @Override
    public boolean hasRequiredItems(List<ItemStack> requiredItems) {
        return true;
    }

    @Override
    public void prePlacementLogic(BlockPos worldPos, BlockState blockState, List<ItemStack> requiredItems) {
    }

    @Override
    public BlockState getSolidBlockForPos(BlockPos worldPos, Function<BlockPos, BlockState> virtualBlocks) {
        return BlockUtils.getSubstitutionBlockAtWorld(this.getWorld(), worldPos, virtualBlocks);
    }
}

