/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement;

import com.ldtteam.structurize.api.constants.Constants;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class BlueprintIteratorRandom
extends AbstractBlueprintIterator {
    final List<BlockPos> positions = new ArrayList<BlockPos>();

    public BlueprintIteratorRandom(IStructureHandler structureHandler) {
        super(structureHandler, new BlockPos(structureHandler.getBluePrint().getSizeX(), (int)structureHandler.getBluePrint().getSizeY(), structureHandler.getBluePrint().getSizeZ()));
        for (int x = 0; x < this.size.getX(); ++x) {
            for (int z = 0; z < this.size.getZ(); ++z) {
                this.positions.add(new BlockPos(x, 0, z));
            }
        }
        Collections.shuffle(this.positions, Constants.rand);
    }

    @Override
    public AbstractBlueprintIterator.Result increment() {
        this.prevProgressPos.set((Vec3i)this.progressPos);
        if (this.progressPos.equals((Object)NULL_POS)) {
            this.progressPos.set(this.positions.get(0).getX(), 0, this.positions.get(0).getZ());
            return AbstractBlueprintIterator.Result.NEW_BLOCK;
        }
        int index = this.positions.indexOf(new BlockPos(this.progressPos.getX(), 0, this.progressPos.getZ())) + 1;
        if (index >= this.positions.size()) {
            this.progressPos.set(this.positions.get(0).getX(), this.progressPos.getY() + 1, this.positions.get(0).getZ());
            if (this.progressPos.getY() >= this.size.getY()) {
                this.reset();
                return AbstractBlueprintIterator.Result.AT_END;
            }
            return AbstractBlueprintIterator.Result.NEW_BLOCK;
        }
        this.progressPos.set(this.positions.get(index).getX(), this.progressPos.getY(), this.positions.get(index).getZ());
        return AbstractBlueprintIterator.Result.NEW_BLOCK;
    }

    @Override
    public AbstractBlueprintIterator.Result decrement() {
        this.prevProgressPos.set((Vec3i)this.progressPos);
        if (this.progressPos.equals((Object)NULL_POS)) {
            this.progressPos.set(this.positions.get(0).getX(), this.size.getY() - 1, this.positions.get(0).getZ());
            return AbstractBlueprintIterator.Result.NEW_BLOCK;
        }
        int index = this.positions.indexOf(new BlockPos(this.progressPos.getX(), 0, this.progressPos.getZ())) + 1;
        if (index >= this.positions.size()) {
            this.progressPos.set(this.positions.get(0).getX(), this.progressPos.getY() - 1, this.positions.get(0).getZ());
            if (this.progressPos.getY() < 0) {
                this.reset();
                return AbstractBlueprintIterator.Result.AT_END;
            }
            return AbstractBlueprintIterator.Result.NEW_BLOCK;
        }
        this.progressPos.set(this.positions.get(index).getX(), this.progressPos.getY(), this.positions.get(index).getZ());
        return AbstractBlueprintIterator.Result.NEW_BLOCK;
    }
}

