/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.operations;

import com.ldtteam.structurize.operations.BaseOperation;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.BlueprintPositionInfo;
import com.ldtteam.structurize.util.ChangeStorage;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.TriPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceStructureOperation
extends BaseOperation {
    @NotNull
    private final StructurePlacer placer;
    private int structurePhase = 0;
    private BlockPos currentPos;

    public PlaceStructureOperation(@NotNull StructurePlacer placer, @Nullable Player player) {
        super(new ChangeStorage((Component)Component.translatable((String)"com.ldtteam.structurize.place_structure", (Object[])new Object[]{Objects.requireNonNullElse(placer.getHandler().getBluePrint().getName(), "[NULL]")}), player != null ? player.getUUID() : UUID.randomUUID()));
        this.placer = placer;
        this.currentPos = AbstractBlueprintIterator.NULL_POS;
    }

    @Override
    public boolean apply(ServerLevel world) {
        if (this.placer.isReady() && this.placer.getHandler().getWorld().dimension().location().equals((Object)world.dimension().location())) {
            StructurePhasePlacementResult result;
            switch (this.structurePhase) {
                case 0: {
                    result = this.placer.executeStructureStep((Level)world, this.storage, this.currentPos, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> this.placer.getIterator().increment((TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler>)((TriPredicate)(info, pos, handler) -> !BlockUtils.canBlockFloatInAir(info.getBlockInfo().getState()))), false);
                    this.currentPos = result.getIteratorPos();
                    break;
                }
                case 1: {
                    result = this.placer.executeStructureStep((Level)world, this.storage, this.currentPos, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> this.placer.getIterator().increment((TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler>)((TriPredicate)(info, pos, handler) -> !BlockUtils.isWeakSolidBlock(info.getBlockInfo().getState()))), false);
                    this.currentPos = result.getIteratorPos();
                    break;
                }
                case 2: {
                    result = this.placer.clearWaterStep((Level)world, this.currentPos);
                    this.currentPos = result.getIteratorPos();
                    if (result.getBlockResult().getResult() != BlockPlacementResult.Result.FINISHED) break;
                    this.currentPos = this.placer.getIterator().getProgressPos();
                    break;
                }
                case 3: {
                    result = this.placer.executeStructureStep((Level)world, this.storage, this.currentPos, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> this.placer.getIterator().increment((TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler>)((TriPredicate)(info, pos, handler) -> BlockUtils.isAnySolid(info.getBlockInfo().getState()))), false);
                    this.currentPos = result.getIteratorPos();
                    break;
                }
                default: {
                    result = this.placer.executeStructureStep((Level)world, this.storage, this.currentPos, StructurePlacer.Operation.SPAWN_ENTITY, () -> this.placer.getIterator().increment((TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler>)((TriPredicate)(info, pos, handler) -> info.getEntities().length == 0)), true);
                    this.currentPos = result.getIteratorPos();
                }
            }
            if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                ++this.structurePhase;
                if (this.structurePhase > 4) {
                    this.structurePhase = 0;
                    this.currentPos = null;
                    this.placer.getHandler().onCompletion();
                }
            }
            return this.currentPos == null;
        }
        return false;
    }
}

