/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.storage.ServerStructurePackLoader;
import com.ldtteam.structurize.storage.StructurePackMeta;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class NotifyServerAboutStructurePacksMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"structurize", (String)"notify_server_about_structure_packs", NotifyServerAboutStructurePacksMessage::new);
    private final Map<String, Double> clientStructurePacks = new HashMap<String, Double>();

    protected NotifyServerAboutStructurePacksMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            this.clientStructurePacks.put(buf.readUtf(Short.MAX_VALUE), buf.readDouble());
        }
    }

    public NotifyServerAboutStructurePacksMessage(Collection<StructurePackMeta> clientStructurePacks) {
        super(TYPE);
        for (StructurePackMeta pack : clientStructurePacks) {
            this.clientStructurePacks.put(pack.getName(), pack.getVersion());
        }
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.clientStructurePacks.size());
        for (Map.Entry<String, Double> packInfo : this.clientStructurePacks.entrySet()) {
            buf.writeUtf(packInfo.getKey());
            buf.writeDouble(packInfo.getValue().doubleValue());
        }
    }

    protected void onExecute(IPayloadContext context, ServerPlayer player) {
        ServerStructurePackLoader.onClientSyncAttempt(this.clientStructurePacks, player);
    }
}

