/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.items.ItemTagSubstitution;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class AbsorbBlockMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"structurize", (String)"absorb_block", AbsorbBlockMessage::new);
    private final BlockPos pos;
    private final ItemStack stack;

    public AbsorbBlockMessage(@NotNull BlockPos pos, @NotNull ItemStack stack) {
        super(TYPE);
        this.pos = pos;
        this.stack = stack;
    }

    protected AbsorbBlockMessage(@NotNull RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.pos = buf.readBlockPos();
        this.stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        ItemStack.STREAM_CODEC.encode((Object)buf, (Object)this.stack);
    }

    protected void onExecute(IPayloadContext context, ServerPlayer player) {
        ItemStack current = player.getInventory().getSelected();
        Item item = current.getItem();
        if (item instanceof ItemTagSubstitution) {
            ItemTagSubstitution anchor = (ItemTagSubstitution)item;
            anchor.onAbsorbBlock(player, current, this.pos, this.stack);
        }
    }
}

