/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.google.common.collect.ImmutableList;
import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.api.ItemStackUtils;
import com.ldtteam.structurize.api.ItemStorage;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.client.gui.WindowScan;
import com.ldtteam.structurize.client.gui.WindowShapeTool;
import com.ldtteam.structurize.network.messages.ReplaceBlockMessage;
import com.ldtteam.structurize.util.BlockUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.StringUtils;

public class WindowReplaceBlock
extends AbstractWindowSkeleton {
    private static final String BUTTON_DONE = "done";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String INPUT_NAME = "name";
    private static final String WINDOW_REPLACE_BLOCK = ":gui/windowreplaceblock.xml";
    private final ItemStack from;
    private final BlockPos pos1;
    private static final int WHITE = Color.getByName((String)"white", (int)0);
    private final BlockPos pos2;
    private final List<ItemStorage> allItems = new ArrayList<ItemStorage>();
    private List<ItemStorage> filteredItems = new ArrayList<ItemStorage>();
    private final ScrollingList resourceList;
    private String filter = "";
    private final boolean mainBlock;
    private final BOWindow origin;
    private int tick;

    public WindowReplaceBlock(ItemStack initialStack, BlockPos pos1, BlockPos pos2, BOWindow origin) {
        super("structurize:gui/windowreplaceblock.xml");
        this.from = initialStack;
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.mainBlock = false;
        this.resourceList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.origin = origin;
        ((TextField)this.findPaneOfTypeByID("pct", TextField.class)).setText("100");
    }

    public WindowReplaceBlock(ItemStack initialStack, BlockPos pos, boolean main, BOWindow origin) {
        super("structurize:gui/windowreplaceblock.xml");
        this.from = initialStack;
        this.pos1 = pos;
        this.pos2 = BlockPos.ZERO;
        this.mainBlock = main;
        this.resourceList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.origin = origin;
        ((TextField)this.findPaneOfTypeByID("pct", TextField.class)).hide();
        ((Text)this.findPaneOfTypeByID("pctlabel", Text.class)).hide();
    }

    public void onOpened() {
        ((ItemIcon)this.findPaneOfTypeByID("resourceIconFrom", ItemIcon.class)).setItem(this.from);
        ((Text)this.findPaneOfTypeByID("resourceNameFrom", Text.class)).setText((MutableComponent)this.from.getHoverName());
        ((ItemIcon)this.findPaneOfTypeByID("resourceIconTo", ItemIcon.class)).setItem(new ItemStack((ItemLike)Blocks.AIR));
        ((Text)this.findPaneOfTypeByID("resourceNameTo", Text.class)).setText((MutableComponent)new ItemStack((ItemLike)Blocks.AIR).getHoverName());
        this.updateResources();
        this.updateResourceList();
        ((TextField)this.findPaneOfTypeByID(INPUT_NAME, TextField.class)).setHandler(input -> {
            String filterNew = ((TextField)this.findPaneOfTypeByID(INPUT_NAME, TextField.class)).getText().toLowerCase(Locale.US);
            if (!filterNew.trim().equals(this.filter)) {
                this.filter = filterNew;
                this.tick = 10;
            }
        });
        this.registerButton(BUTTON_DONE, this::doneClicked);
        this.registerButton(BUTTON_CANCEL, (Button button) -> this.origin.open());
        this.registerButton("select", (Button button) -> {
            int row = this.resourceList.getListElementIndexByPane((Pane)button);
            ItemStack to = this.filteredItems.get(row).getItemStack();
            ((ItemIcon)this.findPaneOfTypeByID("resourceIconTo", ItemIcon.class)).setItem(to);
            ((Text)this.findPaneOfTypeByID("resourceNameTo", Text.class)).setText(to.getHoverName());
        });
    }

    private void updateResources() {
        this.allItems.clear();
        this.allItems.addAll((Collection<ItemStorage>)ImmutableList.copyOf((Collection)StreamSupport.stream(Spliterators.spliteratorUnknownSize(BuiltInRegistries.ITEM.iterator(), 16), false).filter(item -> item instanceof AirItem || item instanceof BlockItem || item instanceof BucketItem && ((BucketItem)item).content != Fluids.EMPTY).map(s -> new ItemStorage(new ItemStack((ItemLike)s))).collect(Collectors.toList())));
        for (ItemStack stack : Minecraft.getInstance().player.getInventory().items) {
            if (this.allItems.contains(new ItemStorage(stack))) continue;
            ItemStack copy = stack.copy();
            copy.setCount(1);
            this.allItems.add(new ItemStorage(copy));
        }
        this.filteredItems = this.allItems;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.tick > 0 && --this.tick == 0) {
            this.filteredItems = this.filter.isEmpty() ? this.allItems : this.allItems.stream().filter(stack -> stack.getItemStack().getDescriptionId().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.getItemStack().getHoverName().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))).collect(Collectors.toList());
            this.filteredItems.sort(Comparator.comparingInt(s1 -> StringUtils.getLevenshteinDistance((CharSequence)s1.getItemStack().getHoverName().getString(), (CharSequence)this.filter)));
        }
    }

    public void doneClicked(Button button) {
        ItemStack to = ((ItemIcon)this.findPaneOfTypeByID("resourceIconTo", ItemIcon.class)).getItem();
        if (!ItemStackUtils.isEmpty(to) || to.getItem() instanceof AirItem) {
            if (this.origin instanceof WindowScan) {
                int pctNum;
                BlockState fromBS = BlockUtils.getBlockStateFromStack(this.from);
                BlockState toBS = BlockUtils.getBlockStateFromStack(to);
                ArrayList missingProperties = new ArrayList(toBS.getProperties());
                missingProperties.removeAll(fromBS.getProperties());
                if (!missingProperties.isEmpty()) {
                    Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"structurize.gui.replaceblock.ambiguous_properties", (Object[])new Object[]{fromBS.getBlock().getName(), toBS.getBlock().getName(), missingProperties.stream().map(prop -> this.getPropertyName((Property<?>)prop) + " - " + prop.getName()).collect(Collectors.joining(", ", "[", "]"))}), false);
                }
                if (toBS.is(ModBlocks.NULL_PLACEMENT)) {
                    Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"structurize.gui.replaceblock.null_placement", (Object[])new Object[]{toBS.getBlock().getName()}), false);
                }
                String pct = ((TextField)this.findPaneOfTypeByID("pct", TextField.class)).getText();
                try {
                    pctNum = Integer.parseInt(pct);
                }
                catch (NumberFormatException ex) {
                    pctNum = 100;
                    Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"structurize.gui.replaceblock.badpct"), false);
                }
                new ReplaceBlockMessage(this.pos1, this.pos2, this.from, to, pctNum).sendToServer();
            } else if (this.origin instanceof WindowShapeTool) {
                ((WindowShapeTool)this.origin).updateBlock(to, this.mainBlock);
            }
            this.origin.open();
        }
    }

    public void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowReplaceBlock.this.filteredItems.size();
            }

            public void updateElement(int index, Pane rowPane) {
                ItemStack resource = WindowReplaceBlock.this.filteredItems.get(index).getItemStack();
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                resourceLabel.setText((MutableComponent)resource.getHoverName());
                resourceLabel.setColors(WHITE);
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
            }
        });
    }

    private String getPropertyName(Property<?> clazz) {
        return clazz instanceof BooleanProperty ? "Boolean" : (clazz instanceof IntegerProperty ? "Integer" : (clazz instanceof EnumProperty ? "Enum" : (clazz instanceof DirectionProperty ? "Direction" : clazz.getClass().getSimpleName())));
    }
}

