/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blueprints.v1;

import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.client.BlueprintBlockInfoTransformHandler;
import com.ldtteam.structurize.client.BlueprintEntityInfoTransformHandler;
import com.ldtteam.structurize.util.BlockEntityInfo;
import com.ldtteam.structurize.util.BlockInfo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public final class BlueprintUtils {
    private BlueprintUtils() {
        throw new IllegalArgumentException("Utils class");
    }

    public static Map<BlockPos, BlockEntity> instantiateTileEntities(Blueprint blueprint, Level beLevel, Map<BlockPos, ModelData> teModelData) {
        return blueprint.getBlockInfoAsList().stream().map(blockInfo -> BlueprintBlockInfoTransformHandler.getInstance().Transform((BlockInfo)blockInfo)).filter(BlockInfo::hasTileEntityData).map(blockInfo -> {
            @Nullable BlockEntity be = BlueprintUtils.constructTileEntity(blockInfo, beLevel, blueprint.getRegistryAccess());
            if (be != null) {
                teModelData.put(blockInfo.getPos(), be.getModelData());
                return new BlockEntityInfo(blockInfo.getPos(), be);
            }
            Log.getLogger().error("TileEntity creation failed for: " + String.valueOf(blueprint) + " " + String.valueOf(blockInfo.getPos()));
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(BlockEntityInfo::pos, BlockEntityInfo::blockEntity));
    }

    public static List<Entity> instantiateEntities(Blueprint blueprint, Level entityLevel) {
        return blueprint.getEntitiesAsList().stream().map(entityInfo -> BlueprintEntityInfoTransformHandler.getInstance().Transform((CompoundTag)entityInfo)).map(entityInfo -> BlueprintUtils.constructEntity(entityInfo, entityLevel)).filter(Objects::nonNull).toList();
    }

    @Nullable
    public static BlockEntity constructTileEntity(BlockInfo info, Level beLevel, HolderLookup.Provider provider) {
        if (info == null || info.getTileEntityData() == null) {
            return null;
        }
        String entityId = info.getTileEntityData().getString("id");
        try {
            CompoundTag compound = info.getTileEntityData().copy();
            compound.putInt("x", info.getPos().getX());
            compound.putInt("y", info.getPos().getY());
            compound.putInt("z", info.getPos().getZ());
            BlockState blockState = info.getState();
            BlockEntity entity = BlockEntity.loadStatic((BlockPos)info.getPos(), (BlockState)Objects.requireNonNull(blockState), (CompoundTag)compound, (HolderLookup.Provider)provider);
            if (entity != null) {
                if (!entity.getType().isValid(blockState)) {
                    Log.getLogger().error("TileEntity " + entityId + " does not accept blockState: " + String.valueOf(blockState));
                    return null;
                }
                if (beLevel != null) {
                    entity.setLevel(beLevel);
                }
            }
            return entity;
        }
        catch (Exception ex) {
            Log.getLogger().error("Could not create tile entity: " + entityId + " with nbt: " + info.toString(), (Throwable)ex);
            return null;
        }
    }

    @Nullable
    private static Entity constructEntity(@Nullable CompoundTag info, Level entityLevel) {
        if (info == null) {
            return null;
        }
        String entityId = info.getString("id");
        try {
            Entity entity;
            CompoundTag compound = info.copy();
            compound.putUUID("UUID", UUID.randomUUID());
            Optional type = EntityType.by((CompoundTag)compound);
            if (type.isPresent() && (entity = ((EntityType)type.get()).create(entityLevel)) != null) {
                entity.load(compound);
                entity.setOldPosAndRot();
                if (entity instanceof LivingEntity) {
                    LivingEntity lentity = (LivingEntity)entity;
                    lentity.yHeadRotO = lentity.yHeadRot;
                    lentity.yBodyRotO = lentity.yBodyRot;
                }
                return entity;
            }
            return null;
        }
        catch (Exception ex) {
            Log.getLogger().error("Could not create entity: " + entityId + " with nbt: " + info.toString(), (Throwable)ex);
            return null;
        }
    }
}

