/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize;

import com.ldtteam.common.config.Configurations;
import com.ldtteam.common.language.LanguageHandler;
import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.blockentities.ModBlockEntities;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blueprints.v1.DataFixerUtils;
import com.ldtteam.structurize.blueprints.v1.DataVersion;
import com.ldtteam.structurize.component.ModDataComponents;
import com.ldtteam.structurize.config.ClientConfiguration;
import com.ldtteam.structurize.config.ServerConfiguration;
import com.ldtteam.structurize.event.ClientEventSubscriber;
import com.ldtteam.structurize.event.ClientLifecycleSubscriber;
import com.ldtteam.structurize.event.EventSubscriber;
import com.ldtteam.structurize.event.LifecycleSubscriber;
import com.ldtteam.structurize.items.ModItemGroups;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.storage.ClientFutureProcessor;
import com.ldtteam.structurize.storage.ClientStructurePackLoader;
import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.storage.ServerStructurePackLoader;
import com.ldtteam.structurize.storage.rendering.ServerPreviewDistributor;
import net.minecraft.util.datafix.DataFixers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="structurize")
public class Structurize {
    private static Configurations<ClientConfiguration, ServerConfiguration, ?> config;

    public Structurize(FMLModContainer modContainer, Dist dist) {
        IEventBus modBus = modContainer.getEventBus();
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        LanguageHandler.loadLangPath((String)"assets/structurize/lang/%s.json");
        config = new Configurations((ModContainer)modContainer, modBus, ClientConfiguration::new, ServerConfiguration::new, null);
        ModDataComponents.REGISTRY.register(modBus);
        ModBlocks.BLOCKS.register(modBus);
        ModItems.ITEMS.register(modBus);
        ModBlockEntities.BLOCK_ENTITIES.register(modBus);
        ModItemGroups.TAB_REG.register(modBus);
        modBus.register(LifecycleSubscriber.class);
        forgeBus.register(EventSubscriber.class);
        if (FMLEnvironment.dist.isClient()) {
            modBus.register(ClientLifecycleSubscriber.class);
            forgeBus.register(ClientEventSubscriber.class);
            forgeBus.register(ClientStructurePackLoader.class);
            forgeBus.register(ClientFutureProcessor.class);
        }
        forgeBus.register(ServerStructurePackLoader.class);
        forgeBus.register(ServerFutureProcessor.class);
        forgeBus.register(ServerPreviewDistributor.class);
        if (DataFixerUtils.isVanillaDF) {
            if (DataFixers.getDataFixer().getSchema(0x7FFFFFFE).getVersionKey() >= DataVersion.UPCOMING.getDataVersion() * 10) {
                throw new RuntimeException("You are trying to run old mod on much newer vanilla. Missing some newest data versions. Please update com/ldtteam/structures/blueprints/v1/DataVersion");
            }
            if (!FMLEnvironment.production && DataVersion.CURRENT == DataVersion.UPCOMING) {
                throw new RuntimeException("Missing some newest data versions. Please update src/main/java/com/ldtteam/structurize/blueprints/v1/DataVersion.java");
            }
        } else {
            Log.getLogger().error("----------------------------------------------------------------- \n Invalid DataFixer detected, schematics might not paste correctly! \nThe following DataFixer was added: " + String.valueOf(DataFixers.getDataFixer().getClass()) + "\n-----------------------------------------------------------------");
        }
    }

    public static Configurations<ClientConfiguration, ServerConfiguration, ?> getConfig() {
        return config;
    }
}

