/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.blocks.lamps;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.items.XyBlockItem;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.core.utils.DyeColors;
import tv.soaryn.xycraft.core.utils.ShapeUtils;
import tv.soaryn.xycraft.world.content.blocks.SidedLightSourceBlock;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

@EventBusSubscriber(modid="xycraft_world", bus=EventBusSubscriber.Bus.MOD)
public class LampPillarBlock
extends SidedLightSourceBlock {
    private static final VoxelShape _pillar = LampPillarBlock.box((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)12.0, (double)9.0);

    public LampPillarBlock(IColorSource color, BlockBehaviour.Properties properties) {
        super(color, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CoreStateProperties.Axis, (Comparable)Direction.Axis.Y));
    }

    public static Supplier<Block> blockSupplier(DyeColor color) {
        return () -> new LampPillarBlock((IColorSource)new ColorSource.Dye(color), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN));
    }

    public static Supplier<Item> itemSupplier(DyeColor dyeColor, DeferredBlock<Block> blockRegistryObject) {
        return () -> new XyBlockItem((Block)blockRegistryObject.get(), new Item.Properties());
    }

    @Override
    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CoreStateProperties.Axis});
    }

    @SubscribeEvent
    private static void attachBlockEntity(RegisterCapabilitiesEvent event) {
        EnumMap<DyeColors, BlockContent> map = WorldContent.Block.LampPillar;
        Block[] lamps = (Block[])map.values().stream().map(BlockContent::block).toArray(Block[]::new);
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, (level, pos, ignored1, ignored2, ignored13) -> (player, interactionHand, hitResult) -> {
            BlockState currentState = level.getBlockState(pos);
            VoxelShape shape = switch ((Direction.Axis)currentState.getValue((Property)CoreStateProperties.Axis)) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> ShapeUtils.rotate((VoxelShape)_pillar, (Direction)Direction.WEST);
                case Direction.Axis.Y -> _pillar;
                case Direction.Axis.Z -> ShapeUtils.rotate((VoxelShape)_pillar, (Direction)Direction.NORTH);
            };
            AABB pillarSelectionBox = shape.move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).bounds().inflate((double)0.01f);
            if (pillarSelectionBox.contains(hitResult.getLocation())) {
                level.setBlock(pos, (BlockState)currentState.cycle((Property)CoreStateProperties.Axis), 8);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            level.setBlock(pos, (BlockState)currentState.cycle((Property)SidedLightSourceBlock.StateProperties.Xl), 8);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }, lamps);
        event.registerBlock(CoreCapabilities.Colorable.BLOCK, LampPillarBlock.coloredLampProvider(map), lamps);
    }

    public VoxelShape getDownShapeForBaking() {
        return MountShape;
    }

    @Override
    public EnumSet<Direction> getValidMountDirections() {
        return EnumSet.allOf(Direction.class);
    }

    @Override
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape shape = switch ((Direction.Axis)state.getValue((Property)CoreStateProperties.Axis)) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> ShapeUtils.rotate((VoxelShape)_pillar, (Direction)Direction.WEST);
            case Direction.Axis.Y -> _pillar;
            case Direction.Axis.Z -> ShapeUtils.rotate((VoxelShape)_pillar, (Direction)Direction.NORTH);
        };
        return Shapes.or((VoxelShape)shape, (VoxelShape)ShapeUtils.rotate((VoxelShape)((Boolean)state.getValue((Property)SidedLightSourceBlock.StateProperties.Xl) != false ? MountShapeXl : MountShape), (Direction)((Direction)state.getValue((Property)CoreStateProperties.StateDirection))));
    }

    @Override
    protected EnumMap<DyeColors, BlockContent> getCurrentMap(int light, BlockState state) {
        return WorldContent.Block.LampPillar;
    }
}

