/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.treetap;

import com.mojang.logging.LogUtils;
import cy.jdkdigital.treetap.client.particle.ColoredParticleType;
import cy.jdkdigital.treetap.common.block.SapCollectorBlock;
import cy.jdkdigital.treetap.common.block.TapBlock;
import cy.jdkdigital.treetap.common.block.entity.SapCollectorBlockEntity;
import cy.jdkdigital.treetap.common.block.entity.TapBlockEntity;
import cy.jdkdigital.treetap.common.item.TapItem;
import cy.jdkdigital.treetap.common.recipe.TapExtractRecipe;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="treetap")
public class TreeTap {
    public static final String MODID = "treetap";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"treetap");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"treetap");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"treetap");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"treetap");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"treetap");
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.PARTICLE_TYPE, (String)"treetap");
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> TAP_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("tap_extract", TapExtractRecipe.Serializer::new);
    public static final DeferredHolder<RecipeType<?>, RecipeType<TapExtractRecipe>> TAP_RECIPE_TYPE = RECIPE_TYPES.register("tap_extract", () -> new RecipeType<TapExtractRecipe>(){});
    public static final DeferredHolder<Block, Block> SAP_COLLECTOR = BLOCKS.register("sap_collector", () -> new SapCollectorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON)));
    public static final DeferredHolder<Block, Block> WOODEN_SAP_COLLECTOR = BLOCKS.register("wooden_sap_collector", () -> new SapCollectorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD)));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<SapCollectorBlockEntity>> SAP_COLLECTOR_BLOCK_ENTITY = BLOCK_ENTITY.register("sap_collector", () -> BlockEntityType.Builder.of(SapCollectorBlockEntity::new, (Block[])new Block[]{(Block)SAP_COLLECTOR.get(), (Block)WOODEN_SAP_COLLECTOR.get()}).build(null));
    public static final DeferredHolder<Block, Block> TAP = BLOCKS.register("tap", () -> new TapBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_BLOCK).noOcclusion(), 1.0f));
    public static final DeferredHolder<Item, Item> TAP_ITEM = ITEMS.register("tap", () -> new TapItem((Block)TAP.get(), new Item.Properties()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<TapBlockEntity>> TAP_BLOCK_ENTITY = BLOCK_ENTITY.register("tap", () -> BlockEntityType.Builder.of(TapBlockEntity::new, (Block[])new Block[]{(Block)TAP.get()}).build(null));
    public static final DeferredHolder<ParticleType<?>, ColoredParticleType> COLORED_DRIP_PARTICLE = PARTICLE_TYPES.register("colored_drip_particle", ColoredParticleType::new);
    public static final TagKey<Block> TAPPABLE = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"treetap", (String)"tappable"));
    public static final TagKey<Item> TAPS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"treetap", (String)"taps"));
    public static final TagKey<Item> METAL_BUCKETS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"treetap", (String)"metal_buckets"));
    public static final TagKey<Item> WOODEN_BUCKETS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"treetap", (String)"wooden_buckets"));

    public TreeTap(IEventBus modEventBus, ModContainer modContainer) {
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITY.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        RECIPE_TYPES.register(modEventBus);
        PARTICLE_TYPES.register(modEventBus);
    }

    public static RecipeHolder<TapExtractRecipe> getRecipe(Level level, BlockState log) {
        if (log.is(TAPPABLE)) {
            List allRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)TAP_RECIPE_TYPE.get());
            for (RecipeHolder tapExtractRecipe : allRecipes) {
                if (!((TapExtractRecipe)tapExtractRecipe.value()).input.test(new ItemStack((ItemLike)log.getBlock()))) continue;
                return tapExtractRecipe;
            }
        }
        return null;
    }

    public static int recipeTickrate(RecipeHolder<TapExtractRecipe> recipe) {
        int mod = ((TapExtractRecipe)recipe.value()).processingTime < 10000 ? 100 : 1000;
        return Math.max(1, ((TapExtractRecipe)recipe.value()).processingTime / mod);
    }
}

