/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.ars.common.machine.component;

import com.hollingsworth.arsnouveau.common.capability.SourceStorage;
import es.degrassi.mmreborn.ars.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SourceComponent
extends MachineComponent<SourceStorage> {
    private final SourceStorage handler;

    public SourceComponent(SourceStorage handler, IOType ioType) {
        super(ioType);
        this.handler = handler;
    }

    public ComponentType getComponentType() {
        return ComponentRegistration.COMPONENT_SOURCE.get();
    }

    @Nullable
    public SourceStorage getContainerProvider() {
        return this.handler;
    }

    public <C extends MachineComponent<?>> C merge(C c) {
        final SourceComponent comp = (SourceComponent)c;
        return (C)((Object)new SourceComponent(new SourceStorage(this.handler.getSourceCapacity() + comp.handler.getSourceCapacity()){

            public int getSource() {
                return SourceComponent.this.handler.getSource() + comp.handler.getSource();
            }

            public int receiveSource(int toReceive, boolean simulate) {
                int received1 = SourceComponent.this.handler.receiveSource(toReceive, simulate);
                int received2 = comp.handler.receiveSource(toReceive -= received1, simulate);
                return received1 + received2;
            }

            public int extractSource(int toExtract, boolean simulate) {
                int extracted1 = SourceComponent.this.handler.extractSource(toExtract, simulate);
                int extracted2 = comp.handler.extractSource(toExtract -= extracted1, simulate);
                return extracted1 + extracted2;
            }
        }, this.getIOType()));
    }
}

