/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.ars.common.block.prop;

import com.hollingsworth.arsnouveau.common.capability.SourceStorage;
import es.degrassi.mmreborn.ars.common.entity.base.SourceHatchEntity;
import es.degrassi.mmreborn.ars.common.network.server.component.SUpdateSourceComponentPacket;
import es.degrassi.mmreborn.common.block.prop.ConfigLoaded;
import java.util.Locale;
import lombok.Generated;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public enum SourceHatchSize implements StringRepresentable,
ConfigLoaded
{
    TINY(100),
    SMALL(400),
    NORMAL(1000),
    REINFORCED(2000),
    BIG(4500),
    HUGE(8000),
    LUDICROUS(16000),
    VACUUM(32000);

    private int size;
    public final int defaultConfigurationValue;

    private SourceHatchSize(int defaultConfigurationValue) {
        this.defaultConfigurationValue = defaultConfigurationValue;
    }

    public static SourceHatchSize value(String value) {
        return switch (value.toUpperCase(Locale.ROOT)) {
            case "SMALL" -> SMALL;
            case "NORMAL" -> NORMAL;
            case "REINFORCED" -> REINFORCED;
            case "BIG" -> BIG;
            case "HUGE" -> HUGE;
            case "LUDICROUS" -> LUDICROUS;
            case "VACUUM" -> VACUUM;
            default -> TINY;
        };
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    public SourceStorage buildTank(SourceHatchEntity sourceHatchEntity, boolean canFill, boolean canDrain) {
        return this.buildDefaultTank(sourceHatchEntity, canFill, canDrain);
    }

    public SourceStorage buildDefaultTank(final SourceHatchEntity sourceHatchEntity, boolean canFill, boolean canDrain) {
        return new SourceStorage(this, this.getSize(), this.getSize(), this.getSize()){

            public void onContentsChanged() {
                Level level = sourceHatchEntity.getLevel();
                if (level instanceof ServerLevel) {
                    ServerLevel l = (ServerLevel)level;
                    PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)l, (ChunkPos)new ChunkPos(sourceHatchEntity.getBlockPos()), (CustomPacketPayload)new SUpdateSourceComponentPacket(sourceHatchEntity.getTank().getSource(), sourceHatchEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        };
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public void setSize(int size) {
        this.size = size;
    }
}

