/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.ars.client.screen;

import es.degrassi.mmreborn.ars.client.container.SourceHatchContainer;
import es.degrassi.mmreborn.ars.client.util.SourceDisplayUtil;
import es.degrassi.mmreborn.ars.client.util.SourceRenderer;
import es.degrassi.mmreborn.ars.common.entity.base.SourceHatchEntity;
import es.degrassi.mmreborn.client.container.ContainerBase;
import es.degrassi.mmreborn.client.screen.BaseScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;

public class SourceHatchScreen
extends BaseScreen<SourceHatchContainer, SourceHatchEntity> {
    public SourceHatchScreen(SourceHatchContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((ContainerBase)pMenu, pPlayerInventory, pTitle);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    public ResourceLocation getTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"modular_machinery_reborn_ars", (String)"textures/gui/guibar.png");
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        guiGraphics.pose().pushPose();
        float percFilled = (float)((SourceHatchEntity)this.entity).getTank().getSource() / (float)((SourceHatchEntity)this.entity).getTank().getMaxSource();
        int pxFilled = Mth.ceil((float)(percFilled * 61.0f));
        SourceRenderer.renderSource(guiGraphics.pose(), pxFilled, this.leftPos + 15, this.topPos + 10 + 61 - pxFilled, 20, pxFilled);
        guiGraphics.pose().popPose();
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        int offsetX = (this.width - this.getXSize()) / 2;
        int offsetZ = (this.height - this.getYSize()) / 2;
        if (x >= 15 + offsetX && x <= 33 + offsetX && y >= 10 + offsetZ && y <= 71 + offsetZ) {
            long currentSource = SourceDisplayUtil.formatSourceForDisplay(((SourceHatchEntity)this.entity).getTank().getSource());
            long maxSource = SourceDisplayUtil.formatSourceForDisplay(((SourceHatchEntity)this.entity).getTank().getMaxSource());
            MutableComponent text = Component.translatable((String)"tooltip.sourcehatch.charge", (Object[])new Object[]{String.valueOf(currentSource), String.valueOf(maxSource)});
            Font font = Minecraft.getInstance().font;
            guiGraphics.renderTooltip(font, (Component)text, x, y);
        }
    }
}

