/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnit;
import appeng.api.implementations.blockentities.ICrankable;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.stacks.AEItemKey;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.grid.AENetworkedPoweredBlockEntity;
import appeng.blockentity.misc.ChargerRecipes;
import appeng.core.AEConfig;
import appeng.core.settings.TickRates;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import com.glodblock.github.extendedae.api.caps.ICrankPowered;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.glodium.util.GlodUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TileExCharger
extends AENetworkedPoweredBlockEntity
implements IGridTickable,
ICrankPowered {
    public static final int POWER_MAXIMUM_AMOUNT = 3200;
    public static final int MAX_THREAD = 4;
    private static final int POWER_THRESHOLD = 3199;
    private boolean working;
    private final AppEngInternalInventory inv = new AppEngInternalInventory((InternalInventoryHost)this, 4, 1, (IAEItemFilter)new ChargerInvFilter(this));

    public TileExCharger(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileExCharger.class, TileExCharger::new, (Block)EAESingletons.EX_CHARGER), pos, blockState);
        this.getMainNode().setFlags(new GridFlags[0]).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(3200.0);
        this.setPowerSides(this.getGridConnectableSides(this.getOrientation()));
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.complementOf(EnumSet.of(orientation.getSide(RelativeSide.FRONT)));
    }

    protected boolean readFromStream(RegistryFriendlyByteBuf data) {
        boolean changed = super.readFromStream(data);
        this.working = data.readBoolean();
        for (int x = 0; x < 4; ++x) {
            if (data.readBoolean()) {
                AEItemKey item = AEItemKey.fromPacket((RegistryFriendlyByteBuf)data);
                this.inv.setItemDirect(x, item.toStack());
                continue;
            }
            this.inv.setItemDirect(x, ItemStack.EMPTY);
        }
        return changed;
    }

    protected void writeToStream(RegistryFriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.working);
        for (int x = 0; x < 4; ++x) {
            AEItemKey is = AEItemKey.of((ItemStack)this.inv.getStackInSlot(x));
            data.writeBoolean(is != null);
            if (is == null) continue;
            is.writeToPacket(data);
        }
    }

    protected void onOrientationChanged(BlockOrientation orientation) {
        super.onOrientationChanged(orientation);
        this.setPowerSides(this.getGridConnectableSides(orientation));
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Charger, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.doWork(ticksSinceLastCall);
        return TickRateModulation.FASTER;
    }

    public boolean isWorking() {
        return this.working;
    }

    @Override
    @Nullable
    public ICrankable getCrankable(Direction direction) {
        if (direction != this.getFront()) {
            return new AENetworkedPoweredBlockEntity.Crankable((AENetworkedPoweredBlockEntity)this);
        }
        return null;
    }

    private void doWork(int ticksSinceLastCall) {
        boolean wasWorking = this.working;
        this.working = false;
        boolean changed = false;
        if (this.level == null) {
            return;
        }
        for (int x = 0; x < 4; ++x) {
            ItemStack myItem = this.inv.getStackInSlot(x);
            if (!myItem.isEmpty()) {
                if (Platform.isChargeable((ItemStack)myItem)) {
                    double maxPower;
                    IAEItemPowerStorage ps = (IAEItemPowerStorage)myItem.getItem();
                    double currentPower = ps.getAECurrentPower(myItem);
                    if (currentPower < (maxPower = ps.getAEMaxPower(myItem))) {
                        double chargeRate = ps.getChargeRate(myItem) * (double)ticksSinceLastCall * AEConfig.instance().getChargerChargeRate();
                        double extractedAmount = this.extractAEPower(chargeRate, Actionable.MODULATE, PowerMultiplier.CONFIG);
                        double missingChargeRate = chargeRate - extractedAmount;
                        double missingAEPower = maxPower - currentPower;
                        double toExtract = Math.min(missingChargeRate, missingAEPower);
                        IGrid grid2 = this.getMainNode().getGrid();
                        if (grid2 != null) {
                            extractedAmount += grid2.getEnergyService().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                        }
                        if (extractedAmount > 0.0) {
                            double adjustment = ps.injectAEPower(myItem, extractedAmount, Actionable.MODULATE);
                            this.setInternalCurrentPower(this.getInternalCurrentPower() + adjustment);
                            this.working = true;
                            changed = true;
                        }
                    }
                } else if (this.getInternalCurrentPower() > 3199.0 && ChargerRecipes.findRecipe((Level)this.level, (ItemStack)myItem) != null) {
                    this.working = true;
                    if (this.level.getRandom().nextFloat() > 0.8f) {
                        this.extractAEPower(this.getInternalMaxPower(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                        ItemStack charged = Objects.requireNonNull(ChargerRecipes.findRecipe((Level)this.level, (ItemStack)myItem)).result;
                        this.inv.setItemDirect(x, charged.copy());
                        changed = true;
                    }
                }
            }
            if (!(this.getInternalCurrentPower() < 3199.0)) continue;
            this.getMainNode().ifPresent(grid -> {
                double toExtract = Math.min(800.0, this.getInternalMaxPower() - this.getInternalCurrentPower());
                double extracted = grid.getEnergyService().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                this.injectExternalPower(PowerUnit.AE, extracted, Actionable.MODULATE);
            });
            changed = true;
        }
        if (changed || this.working != wasWorking) {
            this.markForUpdate();
        }
    }

    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    public void onChangeInventory(AppEngInternalInventory inv, int slot) {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        this.markForUpdate();
    }

    public void activate(Player player) {
        ItemStack stored;
        int x;
        if (!Platform.hasPermissions((DimensionalBlockPos)new DimensionalBlockPos((BlockEntity)this), (Player)player)) {
            return;
        }
        for (x = 0; x < 4; ++x) {
            stored = this.inv.getStackInSlot(x);
            if (!stored.isEmpty()) continue;
            ItemStack held = player.getInventory().getSelected();
            assert (this.level != null);
            if (ChargerRecipes.findRecipe((Level)this.level, (ItemStack)held) == null && !Platform.isChargeable((ItemStack)held)) continue;
            held = player.getInventory().removeItem(player.getInventory().selected, 1);
            this.inv.setItemDirect(x, held);
            return;
        }
        for (x = 0; x < 4; ++x) {
            stored = this.inv.getStackInSlot(x);
            if (stored.isEmpty()) continue;
            List<ItemStack> drops = List.of(stored);
            this.inv.setItemDirect(x, ItemStack.EMPTY);
            Platform.spawnDrops((Level)player.level(), (BlockPos)this.worldPosition.relative(this.getFront()), drops);
            return;
        }
    }

    private record ChargerInvFilter(TileExCharger chargerBlockEntity) implements IAEItemFilter
    {
        public boolean allowInsert(InternalInventory inv, int i, ItemStack itemstack) {
            if (Platform.isChargeable((ItemStack)itemstack)) {
                return true;
            }
            assert (this.chargerBlockEntity.level != null);
            return ChargerRecipes.allowInsert((Level)this.chargerBlockEntity.level, (ItemStack)itemstack);
        }

        public boolean allowExtract(InternalInventory inv, int slotIndex, int amount) {
            IAEItemPowerStorage ips;
            ItemStack extractedItem = inv.getStackInSlot(slotIndex);
            if (Platform.isChargeable((ItemStack)extractedItem) && (ips = (IAEItemPowerStorage)extractedItem.getItem()).getAECurrentPower(extractedItem) >= ips.getAEMaxPower(extractedItem)) {
                return true;
            }
            assert (this.chargerBlockEntity.level != null);
            return ChargerRecipes.allowExtract((Level)this.chargerBlockEntity.level, (ItemStack)extractedItem);
        }
    }
}

