/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities;

import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.grid.AENetworkedPoweredBlockEntity;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import com.glodblock.github.extendedae.api.IRecipeMachine;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.recipe.CrystalFixerRecipe;
import com.glodblock.github.extendedae.util.RecipeExecutor;
import com.glodblock.github.extendedae.xmod.jade.JadeDataProvider;
import com.glodblock.github.glodium.recipe.CommonRecipeContext;
import com.glodblock.github.glodium.recipe.RecipeSearchContext;
import com.glodblock.github.glodium.recipe.stack.IngredientStack;
import com.glodblock.github.glodium.util.GlodUtil;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TileCrystalFixer
extends AENetworkedPoweredBlockEntity
implements IGridTickable,
IRecipeMachine<RecipeInput, CrystalFixerRecipe>,
JadeDataProvider {
    public static final int POWER_MAXIMUM_AMOUNT = 8000;
    public static final int MAX_PROGRESS = 100;
    private final AppEngInternalInventory inv = new AppEngInternalInventory((InternalInventoryHost)this, 1);
    private final CommonRecipeContext<CrystalFixerRecipe> ctx = new FixerRecipeContext(this);
    private final RecipeExecutor<CrystalFixerRecipe> exec;
    private int progress = 0;

    public TileCrystalFixer(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileCrystalFixer.class, TileCrystalFixer::new, (Block)EAESingletons.CRYSTAL_FIXER), pos, blockState);
        this.getMainNode().setFlags(new GridFlags[0]).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(8000.0);
        this.exec = new RecipeExecutor<CrystalFixerRecipe>(this, r -> new ItemStack((ItemLike)r.getOutput()), 100, 50);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(2, 10, !this.ctx.shouldTick());
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.markForUpdate();
        return this.exec.execute(this.genProgress(), true);
    }

    private int genProgress() {
        if (this.getLevel() == null) {
            return 0;
        }
        return this.getLevel().getRandom().nextInt(2, 4);
    }

    protected BlockState getFacingBlock() {
        if (this.getLevel() == null) {
            return Blocks.AIR.defaultBlockState();
        }
        return this.getLevel().getBlockState(this.getBlockPos().offset(this.getFront().getNormal()));
    }

    protected void setNewBlock(BlockState block) {
        if (this.getLevel() != null) {
            this.getLevel().setBlockAndUpdate(this.getBlockPos().offset(this.getFront().getNormal()), block);
        }
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public void addProgress(int delta) {
        this.progress += delta;
    }

    @Override
    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Override
    public RecipeSearchContext<RecipeInput, CrystalFixerRecipe> getContext() {
        return this.ctx;
    }

    @Override
    public void setWorking(boolean work) {
    }

    @Override
    public InternalInventory getOutput() {
        return VoidInventory.INSTANCE;
    }

    @Override
    public Set<Direction> getOutputSides() {
        return Set.of();
    }

    @Override
    @Nullable
    public IManagedGridNode getNode() {
        return this.getMainNode();
    }

    protected boolean readFromStream(RegistryFriendlyByteBuf data) {
        boolean changed = super.readFromStream(data);
        this.inv.setItemDirect(0, (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)data));
        return changed;
    }

    protected void writeToStream(RegistryFriendlyByteBuf data) {
        super.writeToStream(data);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)data, (Object)this.inv.getStackInSlot(0));
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.of(orientation.getSide(RelativeSide.BACK));
    }

    public void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.saveAdditional(data, registries);
        data.putInt("progress", this.progress);
        this.ctx.save(data);
    }

    public void loadTag(CompoundTag data, HolderLookup.Provider registries) {
        super.loadTag(data, registries);
        this.progress = data.getInt("progress");
        this.ctx.load(data);
    }

    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    public void onChangeInventory(AppEngInternalInventory inv, int slot) {
        this.markForUpdate();
        this.saveChanges();
        this.ctx.onInvChange();
    }

    protected void onOrientationChanged(BlockOrientation orientation) {
        super.onOrientationChanged(orientation);
        this.ctx.onInvChange();
    }

    @Override
    @Nullable
    public IEnergySource getEnergy() {
        return this;
    }

    public void onChanged() {
        this.ctx.onInvChange();
    }

    public void refuel(Player player) {
        if (!Platform.hasPermissions((DimensionalBlockPos)new DimensionalBlockPos((BlockEntity)this), (Player)player)) {
            return;
        }
        Inventory playerInv = player.getInventory();
        ItemStack held = playerInv.getSelected();
        if (held.isEmpty()) {
            ItemStack stuff = this.inv.extractItem(0, Integer.MAX_VALUE, false);
            if (!stuff.isEmpty()) {
                playerInv.placeItemBackInInventory(stuff);
            }
        } else {
            ItemStack notAdded = this.inv.insertItem(0, held, false);
            playerInv.setItem(playerInv.selected, notAdded);
        }
    }

    @Override
    public String jadeID() {
        return "crystal_fixer";
    }

    @Override
    public void collectJadeInfo(CompoundTag tag) {
        tag.putInt("progress", this.progress);
    }

    private static class FixerRecipeContext
    extends CommonRecipeContext<CrystalFixerRecipe> {
        private final TileCrystalFixer host;

        protected FixerRecipeContext(TileCrystalFixer host) {
            super(() -> host.level, CrystalFixerRecipe.TYPE);
            this.host = host;
        }

        public void onInvChange() {
            super.onInvChange();
            this.host.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        }

        public void onFind(@Nullable RecipeHolder<CrystalFixerRecipe> recipe) {
            super.onFind(recipe);
            this.host.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        }

        public RecipeHolder<CrystalFixerRecipe> searchRecipe() {
            if (this.host.getLevel() == null) {
                return null;
            }
            RecipeHolder<CrystalFixerRecipe> recipe = CrystalFixerRecipe.lookup(this.host.getFacingBlock().getBlock(), this.host.getLevel());
            if (recipe != null && this.testRecipe(recipe)) {
                return recipe;
            }
            return null;
        }

        public boolean testRecipe(RecipeHolder<CrystalFixerRecipe> recipeHolder) {
            ItemStack storedFuel;
            IngredientStack.Item fuel;
            CrystalFixerRecipe recipe = (CrystalFixerRecipe)recipeHolder.value();
            Block block = this.host.getFacingBlock().getBlock();
            if (block == recipe.getInput() && (fuel = recipe.getFuel()).checkType((Object)(storedFuel = this.host.inv.getStackInSlot(0).copy()))) {
                fuel.consume((Object)storedFuel);
                return fuel.isEmpty();
            }
            return false;
        }

        public void runRecipe(RecipeHolder<CrystalFixerRecipe> recipeHolder) {
            ItemStack storedFuel;
            CrystalFixerRecipe recipe = (CrystalFixerRecipe)recipeHolder.value();
            IngredientStack.Item fuel = recipe.getFuel();
            if (fuel.checkType((Object)(storedFuel = this.host.inv.getStackInSlot(0)))) {
                fuel.consume((Object)storedFuel);
                this.host.inv.setItemDirect(0, storedFuel);
                if (this.host.getLevel() != null && recipe.roll(this.host.getLevel().getRandom())) {
                    this.host.setNewBlock(recipe.getOutput().defaultBlockState());
                }
            }
        }
    }

    private static class VoidInventory
    implements InternalInventory {
        public static final VoidInventory INSTANCE = new VoidInventory();

        private VoidInventory() {
        }

        public int size() {
            return 1;
        }

        public ItemStack getStackInSlot(int slotIndex) {
            return ItemStack.EMPTY;
        }

        public void setItemDirect(int slotIndex, ItemStack stack) {
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return ItemStack.EMPTY;
        }
    }
}

