/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AE2Button;
import appeng.client.gui.widgets.AETextField;
import appeng.menu.AEBaseMenu;
import com.glodblock.github.extendedae.common.items.tools.ItemConfigModifier;
import com.glodblock.github.extendedae.container.ContainerConfigModifier;
import com.glodblock.github.extendedae.network.EAENetworkHandler;
import com.glodblock.github.extendedae.network.packet.CEAEGenericPacket;
import com.glodblock.github.glodium.network.packet.IMessage;
import com.glodblock.github.glodium.network.packet.sync.ActionMap;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import java.util.regex.Pattern;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiConfigModifier
extends AEBaseScreen<ContainerConfigModifier>
implements IActionHolder {
    private final ActionMap actions = ActionMap.create();
    private ItemConfigModifier.ConfigSettings.Mode mode = ItemConfigModifier.ConfigSettings.Mode.MUL;
    private final AE2Button changeMode = new AE2Button((Component)Component.empty(), b -> EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("set_mode", this.mode.getNext().ordinal())));
    private final AETextField dataInput;
    private static final Pattern NUMBER = Pattern.compile("[0-9]*");

    public GuiConfigModifier(ContainerConfigModifier menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        this.changeMode.setSize(50, 20);
        this.changeMode.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.extendedae.config_modifier.change_mode")));
        this.dataInput = this.widgets.addTextField("data_input");
        this.dataInput.setMaxLength(15);
        this.dataInput.setFilter(NUMBER.asMatchPredicate());
        this.dataInput.setPlaceholder((Component)Component.translatable((String)"gui.extendedae.config_modifier.data_input"));
        this.dataInput.setResponder(this::syncData);
        this.actions.put("init", o -> this.setMode((Integer)o.get(0), (Long)o.get(1)));
        EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("update"));
    }

    private void setMode(int mode, long data) {
        this.mode = ItemConfigModifier.ConfigSettings.Mode.values()[mode];
        this.dataInput.setValue(String.valueOf(data));
    }

    private void syncData(String data) {
        try {
            long sync = Long.parseLong(data);
            EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("set_data", sync));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init() {
        super.init();
        this.changeMode.setPosition(this.leftPos + 12, this.topPos + 22);
        this.addRenderableWidget((GuiEventListener)this.changeMode);
    }

    public void updateBeforeRender() {
        super.updateBeforeRender();
        this.mode = ((ContainerConfigModifier)this.getMenu()).mode;
        this.changeMode.setMessage((Component)Component.translatable((String)("gui.extendedae.config_modifier.mode." + this.mode.getSerializedName())));
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        if (btn == 1 && this.dataInput.isMouseOver(xCoord, yCoord)) {
            this.dataInput.setValue("");
        }
        return super.mouseClicked(xCoord, yCoord, btn);
    }

    @NotNull
    public ActionMap getActionMap() {
        return this.actions;
    }
}

