/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.connections.ConnectionEvent;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class TriggerConnectionEventMessage
extends AbstractColonyServerMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"trigger_connection", TriggerConnectionEventMessage::new);
    private ConnectionEvent connectionEventData;
    private int targetColonyId;

    public TriggerConnectionEventMessage(IColony colony, ConnectionEvent coreConnectionEventData, int targetColonyId) {
        super(TYPE, colony);
        this.connectionEventData = coreConnectionEventData;
        this.targetColonyId = targetColonyId;
    }

    protected TriggerConnectionEventMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.connectionEventData = ConnectionEvent.deserializeByteBuf((FriendlyByteBuf)buf);
        this.targetColonyId = buf.readInt();
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
        if (player == null) {
            return;
        }
        if (colony.getPermissions().hasPermission((Player)player, Action.MANAGE_HUTS)) {
            IColony targetColony = IColonyManager.getInstance().getColonyByDimension(this.targetColonyId, colony.getDimension());
            if (targetColony == null) {
                Log.getLogger().error("Tried to trigger connection event at null colony: {}", (Object)this.targetColonyId);
                return;
            }
            targetColony.getConnectionManager().triggerConnectionEvent(this.connectionEventData);
        }
    }

    @Override
    protected void toBytes(RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        this.connectionEventData.serializeByteBuf((FriendlyByteBuf)buf);
        buf.writeInt(this.targetColonyId);
    }
}

