/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.BlockInfo;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.workorders.IServerWorkOrder;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.blocks.BlockPlantationField;
import com.minecolonies.core.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.core.colony.workorders.WorkOrderPlantationField;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;

public class PlantationFieldBuildRequestMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"plantation_field_build_request", PlantationFieldBuildRequestMessage::new);
    private final BlockPos pos;
    private final String packName;
    private final String path;
    private final RotationMirror rotationMirror;
    private final ResourceKey<Level> dimension;
    private final WorkOrderType workOrderType;
    private final BlockPos builder;

    public PlantationFieldBuildRequestMessage(WorkOrderType workOrderType, @NotNull BlockPos pos, String packName, String path, ResourceKey<Level> dimension, RotationMirror rotationMirror, BlockPos builder) {
        super(TYPE);
        this.workOrderType = workOrderType;
        this.pos = pos;
        this.packName = packName;
        this.path = path;
        this.dimension = dimension;
        this.rotationMirror = rotationMirror;
        this.builder = builder;
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.workOrderType.ordinal());
        buf.writeBlockPos(this.pos);
        buf.writeUtf(this.packName);
        buf.writeUtf(this.path);
        buf.writeUtf(this.dimension.location().toString());
        buf.writeByte(this.rotationMirror.ordinal());
        buf.writeBlockPos(this.builder);
    }

    protected PlantationFieldBuildRequestMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.workOrderType = WorkOrderType.values()[buf.readInt()];
        this.pos = buf.readBlockPos();
        this.packName = buf.readUtf(Short.MAX_VALUE);
        this.path = buf.readUtf(Short.MAX_VALUE);
        this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)buf.readUtf(Short.MAX_VALUE)));
        this.rotationMirror = RotationMirror.values()[buf.readByte()];
        this.builder = buf.readBlockPos();
    }

    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromDim(this.dimension, this.pos);
        if (colony == null) {
            return;
        }
        if (!colony.getPermissions().hasPermission((Player)player, Action.MANAGE_HUTS)) {
            return;
        }
        Optional<Map.Entry> wo = colony.getWorkManager().getWorkOrders().entrySet().stream().filter(entry -> entry.getValue() instanceof WorkOrderPlantationField).filter(entry -> ((IServerWorkOrder)entry.getValue()).getLocation().equals((Object)this.pos)).findFirst();
        if (wo.isPresent()) {
            colony.getWorkManager().removeWorkOrder((Integer)wo.get().getKey());
            return;
        }
        ServerFutureProcessor.queueBlueprint((ServerFutureProcessor.BlueprintProcessingData)new ServerFutureProcessor.BlueprintProcessingData((Future)StructurePacks.getBlueprintFuture((String)this.packName, (String)this.path, (HolderLookup.Provider)colony.getWorld().registryAccess()), player.level(), blueprint -> {
            IBuilding building;
            if (blueprint == null) {
                Log.getLogger().error(String.format("Schematic %s doesn't exist on the server.", this.path));
                return;
            }
            String[] split = this.path.split("/");
            String displayName = split[split.length - 1].replace(".blueprint", "");
            BlockState structureState = ((BlockInfo)blueprint.getBlockInfoAsMap().get(blueprint.getPrimaryBlockOffset())).getState();
            WorkOrderType type = structureState != null && !(structureState.getBlock() instanceof BlockPlantationField) ? WorkOrderType.BUILD : this.workOrderType;
            WorkOrderPlantationField order = WorkOrderPlantationField.create(type, this.packName, this.path, WordUtils.capitalizeFully((String)displayName), this.pos, this.rotationMirror, 0);
            order.setBlueprint((Blueprint)blueprint, colony.getWorld());
            if (!this.builder.equals((Object)BlockPos.ZERO) && (building = colony.getBuildingManager().getBuilding(this.builder)) instanceof AbstractBuildingStructureBuilder) {
                order.setClaimedBy(this.builder);
            }
            colony.getWorkManager().addWorkOrder(order, false);
        }));
    }
}

