/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.minecolonies.api.items.component.ModDataComponents;
import com.minecolonies.api.util.CraftingUtils;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.tags.TagManager;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import net.neoforged.neoforgespi.language.IModFileInfo;
import org.jetbrains.annotations.NotNull;

public class ItemNbtCalculator
implements DataProvider {
    private final PackOutput packOutput;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;

    public ItemNbtCalculator(@NotNull PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        this.packOutput = packOutput;
        this.lookupProvider = lookupProvider;
    }

    @NotNull
    public String getName() {
        return "ItemNBTCalculator";
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        ResourceManager serverResources = ItemNbtCalculator.loadServerData();
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.lookupProvider.thenApply(p -> ItemNbtCalculator.loadRegistryTags(p, serverResources, BuiltInRegistries.INSTRUMENT))).thenApply(p -> ItemNbtCalculator.loadRegistryTags(p, serverResources, BuiltInRegistries.ITEM))).thenApply(p -> ItemNbtCalculator.loadRegistryTags(p, serverResources, BuiltInRegistries.BLOCK))).thenCompose(provider -> {
            ImmutableList.Builder listBuilder = new ImmutableList.Builder();
            CreativeModeTab.ItemDisplayParameters tempDisplayParams = new CreativeModeTab.ItemDisplayParameters(FeatureFlags.REGISTRY.allFlags(), false, provider);
            CraftingUtils.forEachCreativeTabItems(tempDisplayParams, (tab, stacks) -> {
                for (ItemStack item : stacks) {
                    BlockItem blockItem;
                    Block patt1$temp;
                    Item patt0$temp = item.getItem();
                    if (patt0$temp instanceof BlockItem && (patt1$temp = (blockItem = (BlockItem)patt0$temp).getBlock()) instanceof IMateriallyTexturedBlock) {
                        IMateriallyTexturedBlock texturedBlock = (IMateriallyTexturedBlock)patt1$temp;
                        MaterialTextureData.Builder builder = MaterialTextureData.builder();
                        for (IMateriallyTexturedBlockComponent key : texturedBlock.getComponents()) {
                            builder.setComponent(key.getId(), key.getDefault());
                        }
                        ItemStack copy = item.copy();
                        builder.writeToItemStack(copy);
                        listBuilder.add((Object)copy);
                        continue;
                    }
                    listBuilder.add((Object)item);
                }
            });
            listBuilder.add((Object)Items.FILLED_MAP.getDefaultInstance());
            ImmutableList allStacks = listBuilder.build();
            TreeMap<String, Set> keyMapping = new TreeMap<String, Set>();
            ReferenceArraySet typesToRemove = new ReferenceArraySet();
            typesToRemove.add(DataComponents.DAMAGE);
            typesToRemove.add(DataComponents.LORE);
            typesToRemove.add(DataComponents.MAX_STACK_SIZE);
            typesToRemove.add(DataComponents.RARITY);
            typesToRemove.add(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
            ModDataComponents.REGISTRY.getEntries().forEach(arg_0 -> ItemNbtCalculator.lambda$run$4((Set)typesToRemove, arg_0));
            com.ldtteam.structurize.component.ModDataComponents.REGISTRY.getEntries().forEach(arg_0 -> ItemNbtCalculator.lambda$run$5((Set)typesToRemove, arg_0));
            for (ItemStack stack : allStacks) {
                ResourceLocation resourceLocation = ((ResourceKey)stack.getItemHolder().unwrapKey().get()).location();
                ReferenceArraySet keys = new ReferenceArraySet(stack.getComponents().keySet());
                if (stack.getItem() instanceof ArmorItem) {
                    keys.add(DataComponents.DYED_COLOR);
                }
                if (stack.is(Items.FILLED_MAP)) {
                    keys.add(DataComponents.MAP_ID);
                }
                if (!stack.isEnchantable()) {
                    keys.remove(DataComponents.ENCHANTMENTS);
                }
                if (!stack.isRepairable()) {
                    keys.remove(DataComponents.REPAIR_COST);
                }
                if (stack.getAttributeModifiers().modifiers().isEmpty()) {
                    keys.remove(DataComponents.ATTRIBUTE_MODIFIERS);
                }
                keys.removeAll((Collection<?>)typesToRemove);
                keyMapping.compute(resourceLocation.toString(), (arg_0, arg_1) -> ItemNbtCalculator.lambda$run$6((Set)keys, arg_0, arg_1));
            }
            Path path = this.packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "compatibility").file(new ResourceLocation("minecolonies", "itemnbtmatching"), "json");
            JsonArray jsonArray = new JsonArray();
            for (Map.Entry entry : keyMapping.entrySet()) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("item", (String)entry.getKey());
                if (!((Set)entry.getValue()).isEmpty()) {
                    JsonArray subArray = new JsonArray();
                    ((Set)entry.getValue()).forEach(arg_0 -> ((JsonArray)subArray).add(arg_0));
                    jsonObject.add("checkednbtkeys", (JsonElement)subArray);
                }
                jsonArray.add((JsonElement)jsonObject);
            }
            return DataProvider.saveStable((CachedOutput)cache, (JsonElement)jsonArray, (Path)path);
        });
    }

    private static ResourceManager loadServerData() {
        List<PackResources> packs = List.of(ServerPacksSource.createVanillaPackSource(), ResourcePackLoader.createPackForMod((IModFileInfo)ModList.get().getModFileById("neoforge")).openPrimary(new PackLocationInfo("mod/neoforge", (Component)Component.empty(), PackSource.BUILT_IN, Optional.empty())));
        return new MultiPackResourceManager(PackType.SERVER_DATA, packs);
    }

    private static <T> HolderLookup.Provider loadRegistryTags(final @NotNull HolderLookup.Provider provider, @NotNull ResourceManager resources, final @NotNull Registry<T> registry) {
        final ResourceKey registryId = registry.key();
        TagLoader tagLoader = new TagLoader(arg_0 -> registry.getHolder(arg_0), Registries.tagsDirPath((ResourceKey)registryId));
        TagManager.LoadResult loadResult = new TagManager.LoadResult(registryId, tagLoader.loadAndBuild(resources));
        Map<TagKey, List> map = loadResult.tags().entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> TagKey.create((ResourceKey)registryId, (ResourceLocation)((ResourceLocation)entry.getKey())), values -> List.copyOf((Collection)values.getValue())));
        registry.bindTags(map);
        return new HolderLookup.Provider(){

            @NotNull
            public Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
                return provider.listRegistries();
            }

            @NotNull
            public <U> Optional<HolderLookup.RegistryLookup<U>> lookup(@NotNull ResourceKey<? extends Registry<? extends U>> id) {
                if (id.equals((Object)registryId)) {
                    return Optional.of(registry.asLookup());
                }
                return provider.lookup(id);
            }

            @NotNull
            public <V> RegistryOps<V> createSerializationContext(@NotNull DynamicOps<V> ops) {
                return provider.createSerializationContext(ops);
            }
        };
    }

    private static /* synthetic */ Set lambda$run$6(Set keys, String k, Set keysInMap) {
        if (keysInMap == null) {
            keysInMap = new TreeSet<String>();
        }
        for (DataComponentType type : keys) {
            keysInMap.add(BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)type).toString());
        }
        return keysInMap;
    }

    private static /* synthetic */ void lambda$run$5(Set typesToRemove, DeferredHolder t) {
        typesToRemove.add((DataComponentType)t.get());
    }

    private static /* synthetic */ void lambda$run$4(Set typesToRemove, DeferredHolder t) {
        typesToRemove.add((DataComponentType)t.get());
    }
}

