/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathresults;

import com.minecolonies.api.util.Log;
import com.minecolonies.core.debug.messages.DebugOutputMessage;
import com.minecolonies.core.entity.pathfinding.PathFindingStatus;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;

public class PathResult<T extends AbstractPathJob> {
    protected PathFindingStatus status = PathFindingStatus.IN_PROGRESS_COMPUTING;
    private volatile boolean pathReachesDestination = false;
    private Path path = null;
    private Future<Path> pathCalculation = null;
    private T job = null;
    private boolean pathingDoneAndProcessed = false;
    public double costPerDist = 1.0;
    public int searchedNodes = 0;
    private List<UUID> debugWatchers = null;

    public PathFindingStatus getStatus() {
        return this.status;
    }

    public void setStatus(PathFindingStatus s) {
        this.status = s;
    }

    public boolean isInProgress() {
        return this.isComputing() || this.status == PathFindingStatus.IN_PROGRESS_FOLLOWING;
    }

    public boolean isComputing() {
        return this.status == PathFindingStatus.IN_PROGRESS_COMPUTING;
    }

    public boolean failedToReachDestination() {
        return this.isDone() && !this.pathReachesDestination;
    }

    public boolean isPathReachingDestination() {
        return this.isDone() && this.path != null && this.pathReachesDestination;
    }

    public void setPathReachesDestination(boolean value) {
        this.pathReachesDestination = value;
    }

    public boolean isCancelled() {
        return this.status == PathFindingStatus.CANCELLED;
    }

    public int getPathLength() {
        return this.path.getNodeCount();
    }

    public boolean hasPath() {
        return this.path != null;
    }

    @Nullable
    public Path getPath() {
        return this.path;
    }

    public T getJob() {
        return this.job;
    }

    public void setJob(T job) {
        this.job = job;
    }

    public void addTrackingPlayer(UUID uuid) {
        if (uuid == null) {
            Log.getLogger().warn("Trying to add null uuid as tracking player");
        }
        if (this.debugWatchers == null) {
            this.debugWatchers = new ArrayList<UUID>();
        }
        this.debugWatchers.add(uuid);
        if (this.job != null) {
            ((AbstractPathJob)this.job).initDebug();
        }
    }

    public void startJob(ExecutorService executorService) {
        if (this.job != null) {
            this.checkDebugging();
            this.pathCalculation = executorService.submit(this.job);
        }
    }

    private void checkDebugging() {
        if (!PathfindingUtils.trackByType.isEmpty()) {
            Iterator<Map.Entry<String, UUID>> iterator = PathfindingUtils.trackByType.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, UUID> entry = iterator.next();
                Player player = ((AbstractPathJob)this.job).getActualWorld().getPlayerByUUID(entry.getValue());
                if (player == null) {
                    iterator.remove();
                    continue;
                }
                if (player.blockPosition().distManhattan((Vec3i)((AbstractPathJob)this.job).getStart()) > 400 || !this.job.getClass().getSimpleName().toLowerCase().contains(entry.getKey().toLowerCase())) continue;
                this.addTrackingPlayer(entry.getValue());
            }
        }
        if (((AbstractPathJob)this.job).getEntity() != null && PathfindingUtils.trackingMap.containsValue(((AbstractPathJob)this.job).getEntity().getUUID())) {
            for (Map.Entry<UUID, UUID> entry : PathfindingUtils.trackingMap.entrySet()) {
                if (!entry.getValue().equals(((AbstractPathJob)this.job).getEntity().getUUID())) continue;
                this.addTrackingPlayer(entry.getKey());
            }
        }
        if (this.debugWatchers != null) {
            ((AbstractPathJob)this.job).initDebug();
        }
    }

    public void processCalculationResults() {
        if (this.pathingDoneAndProcessed) {
            return;
        }
        try {
            this.path = this.pathCalculation.get();
            this.pathCalculation = null;
            this.setStatus(PathFindingStatus.CALCULATION_COMPLETE);
            List<ServerPlayer> watchers = this.getDebugWatchers();
            ((AbstractPathJob)this.job).syncDebug(watchers);
            if (!watchers.isEmpty()) {
                MutableComponent debugInfo = Component.literal((String)" Finished pathjob:").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)((AbstractPathJob)this.job).toString())).append((Component)Component.literal((String)(" reaches: " + this.path.canReach())).withStyle(this.path.canReach() ? ChatFormatting.GREEN : ChatFormatting.RED).append((Component)Component.literal((String)(" path target:" + String.valueOf(this.path.getTarget()))).withStyle(ChatFormatting.BLUE)));
                Log.getLogger().info(debugInfo.getString());
                for (ServerPlayer player : watchers) {
                    new DebugOutputMessage((Component)debugInfo, false).sendToPlayer(player);
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            Log.getLogger().catching((Throwable)e);
        }
    }

    public boolean isCalculatingPath() {
        return this.pathCalculation != null && !this.pathCalculation.isDone();
    }

    public boolean isDone() {
        if (!this.pathingDoneAndProcessed && this.pathCalculation != null && this.pathCalculation.isDone()) {
            this.processCalculationResults();
            this.pathingDoneAndProcessed = true;
        }
        return this.pathingDoneAndProcessed;
    }

    public void cancel() {
        if (this.pathCalculation != null) {
            this.pathCalculation.cancel(true);
            this.pathCalculation = null;
        }
        this.pathingDoneAndProcessed = true;
    }

    public List<ServerPlayer> getDebugWatchers() {
        ArrayList<ServerPlayer> newList = new ArrayList<ServerPlayer>();
        if (this.job != null && this.debugWatchers != null) {
            for (UUID playerID : this.debugWatchers) {
                Player player = ((AbstractPathJob)this.job).getActualWorld().getPlayerByUUID(playerID);
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                newList.add(serverPlayer);
            }
        }
        return newList;
    }
}

