/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.citizen.citizenhandlers;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSleepHandler;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.interactionhandling.SimpleNotificationInteraction;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobMiner;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CitizenSleepHandler
implements ICitizenSleepHandler {
    private static final double Y_DIFF_WEIGHT = 1.5;
    private static final double TIME_PER_BLOCK = 6.0;
    private static final double MAX_NO_COMPLAIN_DISTANCE = 160.0;
    private final AbstractEntityCitizen citizen;

    public CitizenSleepHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public boolean isAsleep() {
        if (this.citizen.getCitizenData() != null) {
            return this.citizen.getCitizenData().isAsleep();
        }
        return (Boolean)this.citizen.getEntityData().get(AbstractEntityCitizen.DATA_IS_ASLEEP);
    }

    private void setIsAsleep(boolean isAsleep) {
        if (this.citizen.getCitizenData() != null) {
            this.citizen.getCitizenData().setAsleep(isAsleep);
        }
        this.citizen.getEntityData().set(AbstractEntityCitizen.DATA_IS_ASLEEP, (Object)isAsleep);
    }

    @Override
    public boolean trySleep(BlockPos bedLocation) {
        boolean isBed;
        BlockState state = WorldUtil.isEntityBlockLoaded((LevelAccessor)this.citizen.level(), bedLocation) ? this.citizen.level().getBlockState(bedLocation) : null;
        boolean bl = isBed = state != null && state.getBlock().isBed(state, (BlockGetter)this.citizen.level(), bedLocation, (LivingEntity)this.citizen);
        if (!isBed) {
            return false;
        }
        this.citizen.setPose(Pose.SLEEPING);
        this.citizen.getNavigation().stop();
        double zOffset = ((Direction)state.getValue((Property)BedBlock.FACING)).getAxis() == Direction.Axis.Z && this.citizen.getCitizenData().isChild() ? 0.0 : 0.5;
        double xOffset = ((Direction)state.getValue((Property)BedBlock.FACING)).getAxis() == Direction.Axis.X && this.citizen.getCitizenData().isChild() ? 0.0 : 0.5;
        this.citizen.setPos((double)bedLocation.getX() + xOffset, (double)bedLocation.getY() + 0.6875, (double)bedLocation.getZ() + zOffset);
        this.citizen.setSleepingPos(bedLocation);
        this.citizen.setDeltaMovement(Vec3.ZERO);
        this.citizen.hasImpulse = true;
        CitizenItemUtils.removeHeldItem(this.citizen);
        this.setIsAsleep(true);
        this.citizen.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.entity.citizen.sleeping", (Object[])new Object[0]), ChatPriority.HIDDEN));
        if (this.citizen.getCitizenData() != null) {
            this.citizen.getCitizenData().setBedPos(bedLocation);
        }
        this.citizen.getEntityData().set(AbstractEntityCitizen.DATA_BED_POS, (Object)bedLocation);
        this.citizen.getCitizenData().getColony().getCitizenManager().onCitizenSleep();
        return true;
    }

    @Override
    public void onWakeUp() {
        this.notifyCitizenHandlersOfWakeUp();
        if (this.isAsleep()) {
            this.spawnCitizenFromBed();
        }
        this.citizen.setPose(Pose.STANDING);
        this.citizen.clearSleepingPos();
        this.setIsAsleep(false);
    }

    private void notifyCitizenHandlersOfWakeUp() {
        IBuilding homeBuilding;
        if (this.citizen.getCitizenColonyHandler().getWorkBuilding() != null) {
            this.citizen.getCitizenColonyHandler().getWorkBuilding().onWakeUp();
        }
        if (this.citizen.getCitizenJobHandler().getColonyJob() != null) {
            this.citizen.getCitizenJobHandler().getColonyJob().onWakeUp();
        }
        if ((homeBuilding = this.citizen.getCitizenColonyHandler().getHomeBuilding()) != null) {
            homeBuilding.onWakeUp();
        }
    }

    private void spawnCitizenFromBed() {
        BlockPos spawn;
        BlockState bedState;
        BlockState blockState = bedState = this.getBedLocation().equals((Object)BlockPos.ZERO) ? null : this.citizen.level().getBlockState(this.getBedLocation());
        if (!this.getBedLocation().equals((Object)BlockPos.ZERO) && bedState.is(BlockTags.BEDS)) {
            if (bedState.getValue((Property)BedBlock.PART) == BedPart.HEAD) {
                BlockPos relPos = this.getBedLocation().relative(((Direction)bedState.getValue((Property)BedBlock.FACING)).getOpposite());
                BlockState lowerState = this.citizen.level().getBlockState(relPos);
                spawn = lowerState.is(BlockTags.BEDS) && lowerState.getValue((Property)BedBlock.PART) == BedPart.FOOT ? EntityUtils.getSpawnPoint(this.citizen.level(), relPos) : EntityUtils.getSpawnPoint(this.citizen.level(), this.getBedLocation());
            } else {
                spawn = EntityUtils.getSpawnPoint(this.citizen.level(), this.getBedLocation());
            }
        } else {
            spawn = this.citizen.blockPosition();
        }
        if (spawn != null && !spawn.equals((Object)BlockPos.ZERO)) {
            this.citizen.setPos((double)spawn.getX() + 0.5, spawn.getY(), (double)spawn.getZ() + 0.5);
        }
        this.setIsAsleep(false);
        if (this.citizen.getCitizenData() != null) {
            this.citizen.getCitizenData().setBedPos(new BlockPos(0, 0, 0));
        }
        this.citizen.getEntityData().set(AbstractEntityCitizen.DATA_BED_POS, (Object)new BlockPos(0, 0, 0));
    }

    @Override
    public BlockPos getBedLocation() {
        return (BlockPos)this.citizen.getEntityData().get(AbstractEntityCitizen.DATA_BED_POS);
    }

    @Override
    public boolean shouldGoSleep() {
        BlockPos homePos = this.citizen.getCitizenData().getHomePosition();
        BlockPos citizenPos = this.citizen.blockPosition();
        if (homePos == null) {
            return false;
        }
        int additionalDist = 0;
        if (this.citizen.isInvisible()) {
            return false;
        }
        if (this.citizen.getCitizenData().getJob() instanceof JobMiner && this.citizen.getCitizenData().getWorkBuilding().getPosition().getY() - 20 > citizenPos.getY()) {
            BlockPos workPos = this.citizen.getCitizenData().getWorkBuilding().getID();
            additionalDist = (int)BlockPosUtil.getDistance2D(citizenPos, workPos) + Math.abs(citizenPos.getY() - workPos.getY()) * 3;
            citizenPos = workPos;
        }
        int xDiff = Math.abs(homePos.getX() - citizenPos.getX());
        int zDiff = Math.abs(homePos.getZ() - citizenPos.getZ());
        int yDiff = (int)((double)Math.abs(homePos.getY() - citizenPos.getY()) * 1.5);
        double timeNeeded = (Math.sqrt(xDiff * xDiff + zDiff * zDiff + yDiff * yDiff) + (double)additionalDist) * 6.0;
        double timeLeft = (this.citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.WORK_LONGER) == 0.0 ? 12600.0 : 12600.0 + this.citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.WORK_LONGER) * 1000.0) - (double)(this.citizen.level().getDayTime() % 24000L);
        if (timeLeft <= 0.0 || timeLeft - timeNeeded <= 0.0) {
            double workHomeDistance;
            if (this.citizen.getCitizenData().getWorkBuilding() != null && (workHomeDistance = Math.sqrt(BlockPosUtil.getDistanceSquared(homePos, this.citizen.getCitizenData().getWorkBuilding().getID()))) > 160.0) {
                this.citizen.getCitizenData().triggerInteraction(new SimpleNotificationInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.gui.chat.hometoofar", (Object[])new Object[0]), ChatPriority.IMPORTANT));
            }
            return true;
        }
        return false;
    }
}

