/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.guard.training;

import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIInteract;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAITraining<J extends AbstractJob<?, J>, B extends AbstractBuilding>
extends AbstractEntityAIInteract<J, B> {
    private static final int TARGET_SEARCH_CHANCE = 30;
    protected static final int ONE_HUNDRED_PERCENT = 100;
    protected BlockPos currentPathingTarget;
    protected IAIState stateAfterPathing;
    protected int currentAttackDelay = 0;

    public AbstractEntityAITraining(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.IDLE, () -> AIWorkerState.START_WORKING, 1), new AITarget<Object>(AIWorkerState.START_WORKING, () -> AIWorkerState.DECIDE, 1), new AITarget<Object>(AIWorkerState.DECIDE, this::decide, 20), new AITarget<Object>(AIWorkerState.TRAINING_WANDER, this::wander, 200), new AITarget<Object>(AIWorkerState.GO_TO_TARGET, this::pathToTarget, 20));
        this.worker.setCanPickUpLoot(true);
    }

    public IAIState decide() {
        if (!this.isSetup()) {
            return AIWorkerState.DECIDE;
        }
        if (this.worker.getRandom().nextInt(100) < 30) {
            return AIWorkerState.COMBAT_TRAINING;
        }
        return AIWorkerState.TRAINING_WANDER;
    }

    protected abstract boolean isSetup();

    private IAIState wander() {
        if (!EntityNavigationUtils.walkToRandomPosWithin(this.worker, 20, 0.6, this.building.getCorners())) {
            return this.getState();
        }
        return AIWorkerState.DECIDE;
    }

    private IAIState pathToTarget() {
        if (!this.walkToWorkPos(this.currentPathingTarget)) {
            return this.getState();
        }
        return this.stateAfterPathing;
    }

    protected void reduceAttackDelay() {
        if (this.currentAttackDelay > 0) {
            --this.currentAttackDelay;
        }
    }
}

