/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers;

import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.ai.workers.util.IBuilderUndestroyable;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAISkill;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.placementhandlers.DoBlockPlacementHandler;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIInteract<J extends AbstractJob<?, J>, B extends AbstractBuilding>
extends AbstractEntityAISkill<J, B> {
    public static final String RENDER_META_WORKING = "working";
    public static final double XP_PER_BLOCK = 0.05;
    private static final double LEVEL_MODIFIER = 0.85;
    private static final int MIN_WORKING_RANGE = 12;
    private static final int ITEM_PICKUP_RANGE = 3;
    private static final int STUCK_WAIT_TICKS = 20;
    public static final float RANGE_HORIZONTAL_PICKUP = 45.0f;
    public static final float RANGE_VERTICAL_PICKUP = 3.0f;
    private int stillTicks = 0;
    private int previousIndex = 0;
    @Nullable
    private List<BlockPos> items;
    public static final int BLOCK_MINING_DELAY = 500;

    public AbstractEntityAIInteract(@NotNull J job) {
        super(job);
        super.registerTargets(new TickingTransition[0]);
    }

    protected final boolean mineBlock(@NotNull BlockPos blockToMine) {
        return this.mineBlock(blockToMine, this.worker.blockPosition());
    }

    protected boolean mineBlock(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand) {
        return this.mineBlock(blockToMine, safeStand, true, true, null);
    }

    protected final boolean mineBlock(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand, boolean damageTool, boolean getDrops, Runnable blockBreakAction) {
        BlockState curBlockState = this.world.getBlockState(blockToMine);
        @Nullable Block curBlock = curBlockState.getBlock();
        if (curBlock instanceof AirBlock || curBlock instanceof IBuilderUndestroyable || curBlock == Blocks.BEDROCK) {
            if (!curBlockState.getFluidState().isEmpty()) {
                this.world.removeBlock(blockToMine, false);
            }
            return true;
        }
        if (this.checkMiningLocation(blockToMine, safeStand)) {
            return false;
        }
        ItemStack tool = this.worker.getMainHandItem();
        if (getDrops) {
            int fortune = ItemStackUtils.getFortuneOf(tool, this.worker.level());
            List<ItemStack> localItems = new ArrayList<ItemStack>();
            if (!tool.isEmpty() && this.shouldSilkTouchBlock(curBlockState)) {
                ItemStack fakeTool = tool.copy();
                fakeTool.enchant(Utils.getRegistryValue(Enchantments.SILK_TOUCH, this.worker.level()), 1);
                localItems.addAll(BlockPosUtil.getBlockDrops((Level)this.world, blockToMine, fortune, fakeTool, (LivingEntity)this.worker));
            } else {
                localItems.addAll(BlockPosUtil.getBlockDrops((Level)this.world, blockToMine, fortune, tool, (LivingEntity)this.worker));
            }
            localItems = this.increaseBlockDrops(localItems);
            for (ItemStack item : localItems) {
                if (item.getItem() instanceof IDoItem) {
                    InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(DoBlockPlacementHandler.getCorrectDOItem(item, curBlockState, false), (IItemHandler)this.worker.getInventoryCitizen());
                    continue;
                }
                InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(item, (IItemHandler)this.worker.getInventoryCitizen());
            }
            this.onBlockDropReception(localItems);
        }
        this.triggerMinedBlock(blockToMine, curBlockState);
        if (blockBreakAction == null) {
            CitizenItemUtils.breakBlockWithToolInHand(this.worker, blockToMine);
        } else {
            blockBreakAction.run();
        }
        if (tool != ItemStack.EMPTY && damageTool) {
            tool.getItem().inventoryTick(tool, (Level)this.world, (Entity)this.worker, this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(tool.getItem()), true);
        }
        this.worker.getCitizenExperienceHandler().addExperience(0.05);
        this.incrementActionsDone();
        return true;
    }

    public void onBlockDropReception(List<ItemStack> blockDrops) {
    }

    public boolean shouldSilkTouchBlock(BlockState curBlockState) {
        return false;
    }

    protected List<ItemStack> increaseBlockDrops(List<ItemStack> drops) {
        return drops;
    }

    protected void triggerMinedBlock(@NotNull BlockPos position, @NotNull BlockState blockToMine) {
    }

    private boolean checkMiningLocation(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand) {
        BlockState curBlock = this.world.getBlockState(blockToMine);
        if (!this.holdEfficientTool(curBlock, blockToMine)) {
            return true;
        }
        if (safeStand != null && this.walkWithProxy(safeStand) && MathUtils.twoDimDistance(this.worker.blockPosition(), safeStand) > 12.0) {
            return true;
        }
        this.currentWorkingLocation = blockToMine;
        return this.hasNotDelayed(this.getBlockMiningTime(curBlock, blockToMine));
    }

    public int getBlockMiningTime(@NotNull BlockState state, @NotNull BlockPos pos) {
        if (this.worker.getMainHandItem() == null) {
            return (int)state.getDestroySpeed((BlockGetter)this.world, pos);
        }
        return (Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).pvp_mode.get() != false ? 250 : this.calculateWorkerMiningDelay(state, pos);
    }

    private int calculateWorkerMiningDelay(@NotNull BlockState state, @NotNull BlockPos pos) {
        double reduction = 1.0 - this.worker.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.BLOCK_BREAK_SPEED);
        return (int)(500.0 * Math.pow(0.85, (double)this.getBreakSpeedLevel() / 2.0) * (double)this.world.getBlockState(pos).getDestroySpeed((BlockGetter)this.world, pos) / (double)this.worker.getMainHandItem().getItem().getDestroySpeed(this.worker.getMainHandItem(), state) * reduction);
    }

    public int getBreakSpeedLevel() {
        return this.getPrimarySkillLevel();
    }

    public void fillItemsList() {
        this.searchForItems(this.worker.getBoundingBox().expandTowards(45.0, 3.0, 45.0).expandTowards(-45.0, -3.0, -45.0));
    }

    public void searchForItems(AABB boundingBox) {
        this.items = this.world.getEntitiesOfClass(ItemEntity.class, boundingBox).stream().filter(item -> item != null && item.isAlive() && (!item.getPersistentData().contains("PreventRemoteMovement") || !item.getPersistentData().getBoolean("PreventRemoteMovement")) && this.isItemWorthPickingUp(item.getItem())).map(BlockPosUtil::fromEntity).collect(Collectors.toList());
    }

    protected boolean isItemWorthPickingUp(ItemStack stack) {
        return true;
    }

    public void gatherItems() {
        this.worker.setCanPickUpLoot(true);
        if (this.worker.getNavigation().isDone() || this.worker.getNavigation().getPath() == null) {
            BlockPos pos = this.getAndRemoveClosestItemPosition();
            EntityNavigationUtils.walkToPos(this.worker, pos, 2, false);
            return;
        }
        int currentIndex = this.worker.getNavigation().getPath().getNextNodeIndex();
        if (currentIndex != this.previousIndex) {
            this.stillTicks = 0;
            this.previousIndex = currentIndex;
            return;
        }
        ++this.stillTicks;
        if (this.stillTicks > 20) {
            this.worker.getNavigation().stop();
            if (this.items != null && !this.items.isEmpty()) {
                this.items.remove(0);
            }
        }
    }

    private BlockPos getAndRemoveClosestItemPosition() {
        int index = 0;
        double distance = Double.MAX_VALUE;
        for (int i = 0; i < this.items.size(); ++i) {
            double tempDistance = this.items.get(i).distSqr((Vec3i)this.worker.blockPosition());
            if (!(tempDistance < distance)) continue;
            index = i;
            distance = tempDistance;
        }
        return this.items.remove(index);
    }

    public void resetGatheringItems() {
        this.items = null;
    }

    @Nullable
    public List<BlockPos> getItemsForPickUp() {
        return this.items == null ? null : new ArrayList<BlockPos>(this.items);
    }
}

