/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.datalistener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.constant.ColonyConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecruitmentItemsListener
extends SimpleJsonResourceReloadListener {
    public static int BASE_RECRUIT_LEVEL = 15;
    public static int MAX_RARITY = 9;
    public static int BASE_ITEM_COUNT = 5;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String KEY_ITEM = "item";
    public static final String KEY_RARITY = "rarity";
    private static Map<Integer, List<RecruitCost>> RECRUIT_COSTS = new HashMap<Integer, List<RecruitCost>>();
    private static final Map<Integer, ItemStack> RARITY_TO_BOOT_MAP = Map.ofEntries(Map.entry(1, new ItemStack((ItemLike)Items.LEATHER_BOOTS)), Map.entry(2, new ItemStack((ItemLike)Items.LEATHER_BOOTS)), Map.entry(3, new ItemStack((ItemLike)Items.GOLDEN_BOOTS)), Map.entry(4, new ItemStack((ItemLike)Items.GOLDEN_BOOTS)), Map.entry(5, new ItemStack((ItemLike)Items.IRON_BOOTS)), Map.entry(6, new ItemStack((ItemLike)Items.IRON_BOOTS)), Map.entry(7, new ItemStack((ItemLike)Items.DIAMOND_BOOTS)), Map.entry(8, new ItemStack((ItemLike)Items.DIAMOND_BOOTS)), Map.entry(9, new ItemStack((ItemLike)Items.NETHERITE_BOOTS)));

    public RecruitmentItemsListener() {
        super(GSON, "colony/recruitment_items");
    }

    @Nullable
    public static RecruitCost getRandomRecruitCost(int buildingLevel) {
        int limit = 3 * buildingLevel + 1;
        int rarity = (int)MathUtils.RANDOM.nextGaussian((double)limit / 2.0, 2.0);
        if (rarity <= 0) {
            rarity = 1;
        } else if (rarity >= limit) {
            rarity = limit - 1;
        }
        List<RecruitCost> recruitCostsAtTier = RECRUIT_COSTS.get(rarity);
        return recruitCostsAtTier.get(ColonyConstants.rand.nextInt(recruitCostsAtTier.size()));
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> jsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        HashMap recruitCosts = new HashMap();
        if (jsonElementMap.isEmpty()) {
            Log.getLogger().error("No recruitment items found, please ensure to add at least one recruitment item, otherwise visitors will be unable to spawn.");
            return;
        }
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonElementMap.entrySet()) {
            if (!entry.getValue().isJsonObject()) {
                return;
            }
            JsonObject object = entry.getValue().getAsJsonObject();
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)object, (String)KEY_ITEM)));
            int rarity = GsonHelper.getAsInt((JsonObject)object, (String)KEY_RARITY);
            if (item == Items.AIR) {
                Log.getLogger().error("Recruit cost '" + String.valueOf(entry.getKey()) + "' item not allowed to be air");
                continue;
            }
            if (rarity > MAX_RARITY || rarity < 1) {
                Log.getLogger().error("Recruit cost with invalid recruitLevel {} needs to be between 1-9", (Object)rarity);
                continue;
            }
            int count = BASE_ITEM_COUNT * (MAX_RARITY + 1 - rarity);
            int recruitLevel = BASE_RECRUIT_LEVEL + rarity * rarity / 2;
            recruitCosts.putIfAbsent(rarity, new ArrayList());
            ((List)recruitCosts.get(rarity)).add(new RecruitCost(new ItemStack((ItemLike)item, count), recruitLevel, RARITY_TO_BOOT_MAP.get(rarity)));
        }
        for (int i = 1; i <= MAX_RARITY; ++i) {
            if (!((List)recruitCosts.getOrDefault(i, new ArrayList())).isEmpty()) continue;
            Log.getLogger().error("No recruitment items found for rarity of {}.", (Object)i);
        }
        RECRUIT_COSTS = Collections.unmodifiableMap(recruitCosts);
    }

    public record RecruitCost(ItemStack recruitItem, int recruitLevel, ItemStack boots) {
    }
}

