/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.arguments;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientSuggestionProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyIdArgument
implements ArgumentType<Result> {
    private static final String HERE = "@here";
    private static final String MINE = "@mine";
    private static final Collection<String> EXAMPLES = List.of("1", "@here", "@mine", "Player", "dd12be42-52a9-4a91-a8a1-11c01849e498");
    private static final SimpleCommandExceptionType ERROR_UNKNOWN_PLAYER = new SimpleCommandExceptionType((Message)Component.translatable((String)"argument.player.unknown"));
    private static final SimpleCommandExceptionType ERROR_UNKNOWN_COLONY = new SimpleCommandExceptionType((Message)Component.translatable((String)"com.minecolonies.command.argument.colony.unknown"));
    private static final Map<String, Message> TOOLTIPS = Map.of("@here", Component.translatable((String)"com.minecolonies.command.argument.colony.here"), "@mine", Component.translatable((String)"com.minecolonies.command.argument.colony.mine"));

    public static ColonyIdArgument id() {
        return new ColonyIdArgument();
    }

    public static int getColonyId(@NotNull CommandContext<CommandSourceStack> context, @NotNull String name) {
        try {
            return ((Result)context.getArgument(name, Result.class)).resolve((CommandSourceStack)context.getSource());
        }
        catch (CommandSyntaxException e) {
            Component message = ComponentUtils.fromMessage((Message)e.getRawMessage());
            ((CommandSourceStack)context.getSource()).sendFailure(message);
            throw new RuntimeException(message.getString());
        }
    }

    @Nullable
    public static IColony tryGetColony(@NotNull CommandContext<CommandSourceStack> context, @NotNull String name, boolean report) {
        int colonyId = ColonyIdArgument.getColonyId(context, name);
        IColony colony = IColonyManager.getInstance().getColonyByWorld(colonyId, (Level)((CommandSourceStack)context.getSource()).getLevel());
        if (colony == null) {
            if (report) {
                MutableComponent message = Component.translatable((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyId});
                ((CommandSourceStack)context.getSource()).sendFailure((Component)message);
            }
            return null;
        }
        return colony;
    }

    @NotNull
    public static IColony getColony(@NotNull CommandContext<CommandSourceStack> context, @NotNull String name) {
        int colonyId = ColonyIdArgument.getColonyId(context, name);
        IColony colony = IColonyManager.getInstance().getColonyByWorld(colonyId, (Level)((CommandSourceStack)context.getSource()).getLevel());
        if (colony == null) {
            MutableComponent message = Component.translatable((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyId});
            ((CommandSourceStack)context.getSource()).sendFailure((Component)message);
            throw new RuntimeException(message.getString());
        }
        return colony;
    }

    public Result parse(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        if (reader.canRead() && reader.peek() == '@') {
            reader.skip();
            String selector = "@" + reader.readUnquotedString();
            if (selector.equals(HERE)) {
                return ColonyIdArgument::resolveHere;
            }
            if (selector.equals(MINE)) {
                return ColonyIdArgument::resolveMine;
            }
            reader.setCursor(i + 1);
            throw EntitySelectorParser.ERROR_UNKNOWN_SELECTOR_TYPE.createWithContext((ImmutableStringReader)reader, (Object)selector);
        }
        if (reader.canRead()) {
            try {
                int id = reader.readInt();
                if (id < 1) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooLow().createWithContext((ImmutableStringReader)reader, (Object)id, (Object)1);
                }
                return source -> id;
            }
            catch (CommandSyntaxException e) {
                reader.setCursor(i);
                String name = reader.readString();
                try {
                    UUID id = UUID.fromString(name);
                    return source -> ColonyIdArgument.resolveTheirs(source, id);
                }
                catch (IllegalArgumentException e2) {
                    if (name.isEmpty() || name.length() > 16) {
                        reader.setCursor(i);
                        throw EntitySelectorParser.ERROR_INVALID_NAME_OR_UUID.createWithContext((ImmutableStringReader)reader);
                    }
                    return source -> ColonyIdArgument.resolveTheirs(source, name);
                }
            }
        }
        throw EntitySelectorParser.ERROR_INVALID_NAME_OR_UUID.createWithContext((ImmutableStringReader)reader);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object object = context.getSource();
        if (object instanceof SharedSuggestionProvider) {
            SharedSuggestionProvider provider = (SharedSuggestionProvider)object;
            ArrayList<String> suggestions = new ArrayList<String>();
            suggestions.add(HERE);
            suggestions.add(MINE);
            ColonyIdArgument.suggestColonyIds(context, suggestions);
            suggestions.addAll(provider.getOnlinePlayerNames());
            return SharedSuggestionProvider.suggest(suggestions, (SuggestionsBuilder)builder, Function.identity(), TOOLTIPS::get);
        }
        return Suggestions.empty();
    }

    private static <S> void suggestColonyIds(CommandContext<S> context, List<String> suggestions) {
        Iterator<IColony> iterator = context.getSource();
        if (iterator instanceof CommandSourceStack) {
            CommandSourceStack source = (CommandSourceStack)iterator;
            for (IColony colony : IColonyManager.getInstance().getIColonies((Level)source.getLevel())) {
                suggestions.add(String.valueOf(colony.getID()));
            }
        } else if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientOnly.suggestColonyIds(context.getSource(), suggestions);
        }
    }

    private static int resolveHere(@NotNull CommandSourceStack source) throws CommandSyntaxException {
        IColony colony = IColonyManager.getInstance().getIColony((Level)source.getLevel(), BlockPos.containing((Position)source.getPosition()));
        if (colony == null) {
            throw ERROR_UNKNOWN_COLONY.create();
        }
        return colony.getID();
    }

    private static int resolveMine(@NotNull CommandSourceStack source) throws CommandSyntaxException {
        return ColonyIdArgument.resolveTheirs(source, source.getPlayerOrException().getGameProfile().getId());
    }

    private static int resolveTheirs(@NotNull CommandSourceStack source, @NotNull String name) throws CommandSyntaxException {
        Optional profile = source.getServer().getProfileCache().get(name);
        if (profile.isPresent()) {
            return ColonyIdArgument.resolveTheirs(source, ((GameProfile)profile.get()).getId());
        }
        throw ERROR_UNKNOWN_PLAYER.create();
    }

    private static int resolveTheirs(@NotNull CommandSourceStack source, @NotNull UUID id) throws CommandSyntaxException {
        IColony colony = IColonyManager.getInstance().getIColonyByOwner((Level)source.getLevel(), id);
        if (colony == null) {
            throw ERROR_UNKNOWN_COLONY.create();
        }
        return colony.getID();
    }

    @FunctionalInterface
    public static interface Result {
        public int resolve(CommandSourceStack var1) throws CommandSyntaxException;
    }

    private static class ClientOnly {
        private ClientOnly() {
        }

        public static <S> void suggestColonyIds(S source, List<String> suggestions) {
            if (source instanceof ClientSuggestionProvider) {
                for (IColony colony : IColonyManager.getInstance().getIColonies((Level)Minecraft.getInstance().level)) {
                    suggestions.add(String.valueOf(colony.getID()));
                }
            }
        }
    }
}

