/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.workorders;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.advancements.CreateBuildRequestTrigger;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.workorders.IBuilderWorkOrder;
import com.minecolonies.api.colony.workorders.IServerWorkOrder;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.colony.buildings.modules.settings.StringSetting;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.core.colony.jobs.AbstractJobStructure;
import com.minecolonies.core.colony.workorders.AbstractWorkOrder;
import com.minecolonies.core.colony.workorders.WorkOrderBuilding;
import com.minecolonies.core.colony.workorders.WorkOrderDecoration;
import com.minecolonies.core.colony.workorders.WorkOrderMiner;
import com.minecolonies.core.util.AdvancementUtils;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkManager
implements IWorkManager {
    private static final String TAG_WORK_ORDERS = "workOrders";
    private static final String TAG_NEW_SYSTEM = "newsystem";
    private final Colony colony;
    @NotNull
    private final Map<Integer, IServerWorkOrder> workOrders = new LinkedHashMap<Integer, IServerWorkOrder>();
    private int topWorkOrderId = 0;
    private boolean dirty = false;

    public WorkManager(Colony c) {
        this.colony = c;
    }

    @Override
    public void removeWorkOrder(@NotNull IServerWorkOrder order) {
        this.removeWorkOrder(order.getID());
    }

    @Override
    public void removeWorkOrder(int orderId) {
        IWorkOrder workOrder = this.workOrders.get(orderId);
        if (workOrder != null) {
            IBuilding building;
            if (workOrder.isClaimed() && (building = this.colony.getBuildingManager().getBuilding(workOrder.getClaimedBy())) instanceof AbstractBuildingStructureBuilder) {
                AbstractBuildingStructureBuilder abstractBuildingStructureBuilder = (AbstractBuildingStructureBuilder)building;
                abstractBuildingStructureBuilder.onWorkOrderCancellation(workOrder);
            }
            this.dirty = true;
            this.workOrders.remove(orderId);
            this.colony.removeWorkOrderInView(orderId);
            if (workOrder instanceof IBuilderWorkOrder) {
                IBuilderWorkOrder builderWorkOrder = (IBuilderWorkOrder)workOrder;
                builderWorkOrder.onRemoved(this.colony);
            }
            this.colony.markDirty();
        }
    }

    @Override
    @Nullable
    public <W extends IServerWorkOrder> W getWorkOrder(int id, @NotNull Class<W> type) {
        IServerWorkOrder workOrder = this.getWorkOrder(id);
        if (type.isInstance(workOrder)) {
            return (W)((IServerWorkOrder)type.cast(workOrder));
        }
        return null;
    }

    @Override
    public IServerWorkOrder getWorkOrder(int id) {
        return this.workOrders.get(id);
    }

    @Override
    @Nullable
    public <W extends IServerWorkOrder> W getUnassignedWorkOrder(@NotNull Class<W> type) {
        for (IWorkOrder iWorkOrder : this.workOrders.values()) {
            if (iWorkOrder.isClaimed() || !type.isInstance(iWorkOrder)) continue;
            return (W)((IServerWorkOrder)type.cast(iWorkOrder));
        }
        return null;
    }

    @Override
    public <W extends IServerWorkOrder> List<W> getWorkOrdersOfType(@NotNull Class<W> type) {
        return this.workOrders.values().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Map<Integer, IServerWorkOrder> getWorkOrders() {
        return this.workOrders;
    }

    @Override
    public void clearWorkForCitizen(@NotNull ICitizenData citizen) {
        this.dirty = true;
        if (citizen.getWorkBuilding() != null) {
            for (IWorkOrder iWorkOrder : this.workOrders.values()) {
                if (!citizen.getWorkBuilding().getPosition().equals((Object)iWorkOrder.getClaimedBy())) continue;
                iWorkOrder.setClaimedBy(null);
            }
        }
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        @NotNull ListTag list = new ListTag();
        for (IServerWorkOrder o : this.workOrders.values()) {
            @NotNull CompoundTag orderCompound = new CompoundTag();
            o.write(orderCompound);
            list.add((Object)orderCompound);
        }
        compound.put(TAG_WORK_ORDERS, (Tag)list);
        compound.putBoolean(TAG_NEW_SYSTEM, true);
    }

    @Override
    public void read(@NotNull CompoundTag compound) {
        this.workOrders.clear();
        if (!compound.contains(TAG_NEW_SYSTEM)) {
            return;
        }
        ListTag list = compound.getList(TAG_WORK_ORDERS, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag orderCompound = list.getCompound(i);
            @Nullable IServerWorkOrder o = AbstractWorkOrder.createFromNBT(orderCompound, this);
            if (o == null) continue;
            this.addWorkOrder(o, true);
            if (o.isClaimed() && this.colony.getBuildingManager().getBuilding(o.getClaimedBy()) == null) {
                o.setClaimedBy(null);
            }
            this.topWorkOrderId = Math.max(this.topWorkOrderId, o.getID());
        }
    }

    @Override
    public void addWorkOrder(@NotNull IServerWorkOrder order, boolean readingFromNbt) {
        this.dirty = true;
        if (!(order instanceof WorkOrderMiner)) {
            for (IServerWorkOrder or : this.workOrders.values()) {
                if (!or.getLocation().equals((Object)order.getLocation()) || !or.getStructurePath().equals(order.getStructurePath()) || !or.getStructurePack().equals(order.getStructurePack())) continue;
                Log.getLogger().warn("Avoiding adding duplicate workOrder");
                this.removeWorkOrder(or);
                break;
            }
            if (!readingFromNbt && !this.isWorkOrderWithinColony(order)) {
                MessageUtils.format("com.minecolonies.coremod.workorder.outofcolony", order.getDisplayName(), order.getLocation().getX(), order.getLocation().getZ()).sendTo(this.colony).forAllPlayers();
                return;
            }
        }
        if (order.getID() == 0) {
            ++this.topWorkOrderId;
            order.setID(this.topWorkOrderId);
        }
        int level = order.getTargetLevel();
        if (!readingFromNbt) {
            if (order instanceof WorkOrderBuilding) {
                WorkOrderBuilding buildingOrder = (WorkOrderBuilding)order;
                IBuilding building = this.colony.getBuildingManager().getBuilding(buildingOrder.getLocation());
                if (building != null) {
                    AdvancementUtils.TriggerAdvancementPlayersForColony(this.colony, player -> ((CreateBuildRequestTrigger)((Object)((Object)AdvancementTriggers.CREATE_BUILD_REQUEST.get()))).trigger((ServerPlayer)player, building.getSchematicName(), level));
                }
            } else if (order instanceof WorkOrderDecoration) {
                AdvancementUtils.TriggerAdvancementPlayersForColony(this.colony, player -> ((CreateBuildRequestTrigger)((Object)((Object)AdvancementTriggers.CREATE_BUILD_REQUEST.get()))).trigger((ServerPlayer)player, order.getFileName().replace(String.valueOf(level), ""), level));
            }
        }
        this.workOrders.put(order.getID(), order);
        order.onAdded(this.colony, readingFromNbt);
    }

    private boolean isWorkOrderWithinColony(IWorkOrder order) {
        ServerLevel world = this.colony.getWorld();
        Blueprint blueprint = StructurePacks.getBlueprint((String)order.getStructurePack(), (String)order.getStructurePath(), (HolderLookup.Provider)world.registryAccess());
        Tuple<BlockPos, BlockPos> corners = ColonyUtils.calculateCorners(order.getLocation(), (Level)world, blueprint, order.getRotationMirror());
        HashSet<ChunkPos> chunks = new HashSet<ChunkPos>();
        int minX = Math.min(((BlockPos)corners.getA()).getX(), ((BlockPos)corners.getB()).getX()) + 1;
        int maxX = Math.max(((BlockPos)corners.getA()).getX(), ((BlockPos)corners.getB()).getX());
        int minZ = Math.min(((BlockPos)corners.getA()).getZ(), ((BlockPos)corners.getB()).getZ()) + 1;
        int maxZ = Math.max(((BlockPos)corners.getA()).getZ(), ((BlockPos)corners.getB()).getZ());
        for (int x = minX; x < maxX; x += 16) {
            for (int z = minZ; z < maxZ; z += 16) {
                int chunkX = x >> 4;
                int chunkZ = z >> 4;
                ChunkPos pos = new ChunkPos(chunkX, chunkZ);
                if (chunks.contains(pos)) continue;
                chunks.add(pos);
                if (ColonyUtils.getOwningColony((ChunkAccess)world.getChunk(pos.x, pos.z)) == this.colony.getID()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        @NotNull Iterator<IServerWorkOrder> iter = this.workOrders.values().iterator();
        while (iter.hasNext()) {
            IServerWorkOrder order = iter.next();
            if (!order.isValid(this.colony)) {
                iter.remove();
                this.dirty = true;
                continue;
            }
            if (order.isDirty()) {
                this.dirty = true;
                order.resetChange();
            }
            if (order.isClaimed() && this.getColony().getBuildingManager().getBuildings().get(order.getClaimedBy()) == null) {
                order.setClaimedBy(BlockPos.ZERO);
            }
            this.tryAssignWorkOrder(order, b -> order.getClaimedBy().equals((Object)b.getPosition()));
        }
        for (IServerWorkOrder wo : colony.getWorkManager().getWorkOrders().values()) {
            this.tryAssignWorkOrder(wo, wo::canBuild);
        }
    }

    private void tryAssignWorkOrder(IServerWorkOrder order, @NotNull Predicate<IBuilding> predicate) {
        for (IBuilding building : this.colony.getBuildingManager().getBuildings().values()) {
            AbstractJobStructure abstractJobStructure;
            IJob<?> iJob;
            ICitizenData citizen;
            if (!(building instanceof AbstractBuildingStructureBuilder) || (citizen = ((WorkerBuildingModule)building.getFirstModuleOccurance(WorkerBuildingModule.class)).getFirstCitizen()) == null || !((iJob = citizen.getJob()) instanceof AbstractJobStructure) || (abstractJobStructure = (AbstractJobStructure)iJob).hasWorkOrder()) continue;
            if (order.isClaimed()) {
                if (!order.getClaimedBy().equals((Object)building.getPosition())) continue;
                abstractJobStructure.setWorkOrder(order);
                order.setClaimedBy(building.getID());
                continue;
            }
            StringSetting setting = building.getSetting(BuildingBuilder.MODE);
            if (setting != null && setting.getValue().equals("com.minecolonies.core.builder.setting.manual") || !predicate.test(building)) continue;
            abstractJobStructure.setWorkOrder(order);
            order.setClaimedBy(building.getID());
        }
    }

    @Override
    public <W extends IServerWorkOrder> List<W> getOrderedList(Class<W> type, BlockPos builder) {
        return this.getOrderedList(type::isInstance, builder).stream().map(m -> m).collect(Collectors.toList());
    }

    @Override
    public List<IServerWorkOrder> getOrderedList(@NotNull Predicate<IServerWorkOrder> predicate, BlockPos builder) {
        return this.workOrders.values().stream().filter(o -> !o.isClaimed() || o.getClaimedBy().equals((Object)builder)).filter(predicate).sorted(Comparator.comparingInt(IWorkOrder::getPriority).reversed()).collect(Collectors.toList());
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public IColony getColony() {
        return this.colony;
    }
}

