/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.managers;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.IResearchEffect;
import com.minecolonies.api.research.IResearchEffectManager;
import com.minecolonies.api.research.IResearchManager;
import com.minecolonies.api.research.ResearchBranchType;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.network.messages.client.colony.ColonyViewResearchManagerViewMessage;
import com.minecolonies.core.research.LocalResearch;
import com.minecolonies.core.research.LocalResearchTree;
import com.minecolonies.core.research.ResearchEffectManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ResearchManager
implements IResearchManager {
    private final LocalResearchTree tree;
    private final IResearchEffectManager effects = new ResearchEffectManager();
    private final List<IGlobalResearch> autoStartResearch = new ArrayList<IGlobalResearch>();
    private final IColony colony;
    private boolean dirty;

    @Override
    public void readFromNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        this.tree.readFromNBT(provider, compound, this.effects);
    }

    @Override
    public void writeToNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        this.tree.writeToNBT(provider, compound);
    }

    @Override
    public void sendPackets(Set<ServerPlayer> closeSubscribers, Set<ServerPlayer> newSubscribers) {
        if (this.dirty || !newSubscribers.isEmpty()) {
            HashSet<ServerPlayer> players = new HashSet<ServerPlayer>();
            if (this.dirty) {
                players.addAll(closeSubscribers);
            }
            players.addAll(newSubscribers);
            new ColonyViewResearchManagerViewMessage(this.colony, this).sendToPlayer(players);
        }
        this.clearDirty();
    }

    @Override
    public final void markDirty() {
        this.dirty = true;
    }

    @Override
    public final boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void clearDirty() {
        this.dirty = false;
    }

    public ResearchManager(IColony colony) {
        this.colony = colony;
        this.autoStartResearch.addAll(MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().getAutostartResearches());
        this.tree = new LocalResearchTree(colony);
    }

    @Override
    public LocalResearchTree getResearchTree() {
        return this.tree;
    }

    @Override
    public IResearchEffectManager getResearchEffects() {
        return this.effects;
    }

    @Override
    public ResourceLocation getResearchEffectIdFrom(Block block) {
        return new ResourceLocation(BuiltInRegistries.BLOCK.getKey((Object)block).getNamespace(), "effects/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath());
    }

    @Override
    public void checkAutoStartResearch() {
        if (this.colony == null || !(this.colony instanceof Colony)) {
            return;
        }
        ArrayList<IGlobalResearch> removes = new ArrayList<IGlobalResearch>();
        for (IGlobalResearch research : this.autoStartResearch) {
            if (!IGlobalResearchTree.getInstance().isResearchRequirementsFulfilled(research.getResearchRequirements(), this.colony)) continue;
            if (IGlobalResearchTree.getInstance().getBranchData(research.getBranch()).getType() != ResearchBranchType.UNLOCKABLES) {
                int level = 0;
                Map<BlockPos, IBuilding> buildings = this.colony.getBuildingManager().getBuildings();
                for (Map.Entry<BlockPos, IBuilding> building : buildings.entrySet()) {
                    if (building.getValue().getBuildingType() != ModBuildings.university.get() || building.getValue().getBuildingLevel() <= level) continue;
                    level = building.getValue().getBuildingLevel();
                }
                if (level < research.getDepth()) continue;
            }
            boolean researchAlreadyRun = false;
            for (ILocalResearch progressResearch : this.colony.getResearchManager().getResearchTree().getResearchInProgress()) {
                if (!progressResearch.getId().equals((Object)research.getId())) continue;
                researchAlreadyRun = true;
                break;
            }
            if (researchAlreadyRun || this.colony.getResearchManager().getResearchTree().hasCompletedResearch(research.getId())) {
                removes.add(research);
                continue;
            }
            if (!research.getCostList().isEmpty()) {
                MessageUtils.format("com.minecolonies.coremod.research.available", MutableComponent.create((ComponentContents)research.getName())).sendTo(this.colony).forAllPlayers();
                for (Player player : this.colony.getMessagePlayerEntities()) {
                    SoundUtils.playSuccessSound(player, player.blockPosition());
                }
            } else {
                this.startCostlessResearch(research);
            }
            removes.add(research);
        }
        this.autoStartResearch.removeAll(removes);
        this.markDirty();
    }

    private void startCostlessResearch(IGlobalResearch research) {
        this.markDirty();
        boolean creativePlayer = false;
        for (Player player : this.colony.getMessagePlayerEntities()) {
            if (!player.isCreative()) continue;
            creativePlayer = true;
        }
        this.tree.addResearch(research.getBranch(), new LocalResearch(research.getId(), research.getBranch(), research.getDepth()));
        if (research.isInstant() || creativePlayer && ((Boolean)((ServerConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getServer()).researchCreativeCompletion.get()).booleanValue()) {
            ILocalResearch localResearch = this.tree.getResearch(research.getBranch(), research.getId());
            localResearch.setProgress(IGlobalResearchTree.getInstance().getBranchData(research.getBranch()).getBaseTime(research.getDepth()));
            localResearch.setState(ResearchState.FINISHED);
            this.tree.finishResearch(research.getId());
            for (IResearchEffect effect : IGlobalResearchTree.getInstance().getResearch(research.getBranch(), research.getId()).getEffects()) {
                this.effects.applyEffect(effect);
            }
            for (ICitizenData citizen : this.colony.getCitizenManager().getCitizens()) {
                citizen.applyResearchEffects();
            }
            MessageUtils.format("com.minecolonies.coremod.university.researchconcluded." + ThreadLocalRandom.current().nextInt(3), MutableComponent.create((ComponentContents)IGlobalResearchTree.getInstance().getResearch(research.getBranch(), research.getId()).getName())).sendTo(this.colony).forAllPlayers();
            for (Player player : this.colony.getMessagePlayerEntities()) {
                SoundUtils.playSuccessSound(player, player.blockPosition());
            }
        } else {
            MessageUtils.format("com.minecolonies.coremod.research.available", MutableComponent.create((ComponentContents)research.getName())).append("com.minecolonies.coremod.research.started", MutableComponent.create((ComponentContents)research.getName())).sendTo(this.colony).forAllPlayers();
            for (Player player : this.colony.getMessagePlayerEntities()) {
                SoundUtils.playSuccessSound(player, player.blockPosition());
            }
        }
    }
}

