/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.BlockInfo;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.AbstractColonyBlock;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ISchematicProvider;
import com.minecolonies.api.colony.buildings.modules.IAltersBuildingFootprint;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.compatibility.newstruct.BlueprintMapping;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.FireworkUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSchematicProvider
implements ISchematicProvider,
IBuilding {
    protected final IColony colony;
    private final BlockPos location;
    private int buildingLevel = 0;
    @Nullable
    private RotationMirror rotationMirror = null;
    private String structurePack = "Colonial";
    private String path = "";
    private int height;
    private BuildingEntry buildingType = null;
    private boolean isDeconstructed;
    private BlockPos lowerCorner = BlockPos.ZERO;
    private BlockPos higherCorner = BlockPos.ZERO;
    private BlockPos parentSchematic = BlockPos.ZERO;
    private Future<Blueprint> blueprintFuture;
    private String blueprintFuturePack = "";
    private String blueprintFutureName = "";

    public AbstractSchematicProvider(BlockPos pos, IColony colony) {
        if (pos.equals((Object)BlockPos.ZERO)) {
            Log.getLogger().warn("Creating building at zero pos!:", (Throwable)new Exception());
        }
        this.location = pos;
        this.colony = colony;
    }

    public int hashCode() {
        return (int)(31L * this.getID().asLong());
    }

    public boolean equals(Object o) {
        return o instanceof AbstractBuilding && ((IBuilding)o).getID().equals((Object)this.getID());
    }

    @Override
    public boolean isDeconstructed() {
        return this.isDeconstructed;
    }

    @Override
    public void setDeconstructed() {
        this.isDeconstructed = true;
    }

    @Override
    public String getBlueprintPath() {
        return this.path;
    }

    @Override
    public void setBlueprintPath(String path) {
        this.path = path;
        this.getTileEntity().setBlueprintPath(path);
        this.markDirty();
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        BlockPosUtil.write(compound, "location", this.location);
        compound.putString("pack", this.structurePack);
        compound.putString("path", this.getBlueprintPath());
        compound.putInt("level", this.buildingLevel);
        compound.putByte("rotMir", (byte)this.getRotationMirror().ordinal());
        this.getCorners();
        BlockPosUtil.write(compound, "corner1", this.lowerCorner);
        BlockPosUtil.write(compound, "corner2", this.higherCorner);
        compound.putInt("height", this.height);
        compound.putBoolean("deconstructed", this.isDeconstructed);
        BlockPosUtil.write(compound, "parent", this.parentSchematic);
        return compound;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        this.buildingLevel = compound.getInt("level");
        this.deserializerStructureInformationFrom(compound);
        this.rotationMirror = RotationMirror.values()[compound.getByte("rotMir")];
        if (compound.contains("corner1") && compound.contains("corner2")) {
            this.setCorners(BlockPosUtil.read(compound, "corner1"), BlockPosUtil.read(compound, "corner2"));
        }
        if (compound.contains("height")) {
            this.height = compound.getInt("height");
        }
        this.isDeconstructed = compound.contains("deconstructed") ? compound.getBoolean("deconstructed") : false;
        this.parentSchematic = BlockPosUtil.read(compound, "parent");
    }

    private void deserializerStructureInformationFrom(CompoundTag compound) {
        AbstractColonyBlock<?> abstractColonyBlock;
        Object path;
        String packName;
        if (compound.contains("style") && !compound.getString("style").isEmpty()) {
            packName = BlueprintMapping.getStyleMapping(compound.getString("style"));
            path = BlueprintMapping.getPathMapping(compound.getString("style"), this.getSchematicName()) + this.buildingLevel + ".blueprint";
        } else {
            packName = compound.getString("pack");
            path = compound.getString("path");
        }
        if ((path == null || ((String)path).isEmpty()) && (abstractColonyBlock = this.getBuildingType().getBuildingBlock()) instanceof AbstractBlockHut) {
            AbstractBlockHut abstractBlockHut = (AbstractBlockHut)abstractColonyBlock;
            path = BlueprintMapping.getPathMapping("", abstractBlockHut.getBlueprintName()) + "1.blueprint";
        }
        this.structurePack = packName;
        this.path = path;
        if (this.structurePack == null || this.structurePack.isEmpty()) {
            Log.getLogger().warn("Loaded empty style, setting to Default");
            this.structurePack = "Colonial";
        }
    }

    @Override
    public IColony getColony() {
        return this.colony;
    }

    @Override
    public BlockPos getPosition() {
        return this.location;
    }

    @Override
    public void setCorners(BlockPos pos1, BlockPos pos2) {
        this.lowerCorner = new BlockPos(Math.min(pos1.getX(), pos2.getX()), Math.min(pos1.getY(), pos2.getY()), Math.min(pos1.getZ(), pos2.getZ()));
        this.higherCorner = new BlockPos(Math.max(pos1.getX(), pos2.getX()), Math.max(pos1.getY(), pos2.getY()), Math.max(pos1.getZ(), pos2.getZ()));
    }

    @Override
    public Tuple<BlockPos, BlockPos> getCorners() {
        if (this.lowerCorner.equals((Object)BlockPos.ZERO) || this.higherCorner.equals((Object)BlockPos.ZERO)) {
            this.calculateCorners();
            if (this.lowerCorner.equals((Object)BlockPos.ZERO) || this.higherCorner.equals((Object)BlockPos.ZERO)) {
                return new Tuple((Object)this.getPosition(), (Object)this.getPosition());
            }
        }
        return new Tuple((Object)this.lowerCorner, (Object)this.higherCorner);
    }

    @Override
    public BlockPos getID() {
        return this.location;
    }

    @Override
    public BlockPos getParent() {
        return this.isParentValid(this.parentSchematic) ? this.parentSchematic : BlockPos.ZERO;
    }

    @Override
    public boolean hasParent() {
        return !this.parentSchematic.equals((Object)BlockPos.ZERO);
    }

    @Override
    public void setParent(BlockPos pos) {
        if (this.isParentValid(pos)) {
            this.parentSchematic = pos;
        }
    }

    private boolean isParentValid(BlockPos position) {
        IBuilding building = this.colony.getBuildingManager().getBuilding(position);
        return building != null && !building.getID().equals((Object)this.getID()) && !building.hasParent();
    }

    @Override
    public Set<BlockPos> getChildren() {
        return this.colony.getBuildingManager().getBuildings().values().stream().filter(f -> f.getParent().equals((Object)this.getID())).map(ISchematicProvider::getID).collect(Collectors.toUnmodifiableSet());
    }

    public void safeUpdateTEDataFromSchematic() {
        if (this.buildingLevel <= 0 || this.blueprintFuture != null) {
            return;
        }
        TileEntityColonyBuilding te = (TileEntityColonyBuilding)this.colony.getWorld().getBlockEntity(this.getPosition());
        try {
            this.unsafeUpdateTEDataFromSchematic(te);
            return;
        }
        catch (Exception ex) {
            Log.getLogger().warn("TileEntity with invalid data, restoring correct data from schematic.");
            te.setSchematicName(this.getSchematicName() + Math.max(1, this.buildingLevel));
            try {
                this.unsafeUpdateTEDataFromSchematic(te);
            }
            catch (Exception ex2) {
                MessageUtils.format("com.minecolonies.coremod.invalidbuilding", this.getSchematicName(), this.getID().getX(), this.getID().getY(), this.getID().getZ(), this.getStructurePack()).sendTo(this.colony).forAllPlayers();
            }
            return;
        }
    }

    @Override
    public void onColonyTick(IColony colony) {
        if (this.blueprintFuture != null && this.blueprintFuture.isDone()) {
            try {
                Blueprint blueprint = this.blueprintFuture.get();
                if (blueprint != null) {
                    blueprint.setRotationMirror(this.getRotationMirror(), colony.getWorld());
                    BlockInfo info = blueprint.getBlockInfoAsMap().getOrDefault(blueprint.getPrimaryBlockOffset(), null);
                    if (info.getTileEntityData() != null) {
                        CompoundTag teCompound = info.getTileEntityData().copy();
                        teCompound.putString("pack", blueprint.getPackName());
                        String location = StructurePacks.getStructurePack((String)blueprint.getPackName()).getSubPath(blueprint.getFilePath().resolve(blueprint.getFileName()));
                        teCompound.putString("name", location);
                        this.getTileEntity().readSchematicDataFromNBT(teCompound);
                    }
                }
            }
            catch (Exception e) {
                Log.getLogger().info("Failed to load blueprintfuture for: pack:" + this.blueprintFuturePack + " name:" + this.blueprintFutureName, (Throwable)e);
                this.blueprintFuture = null;
            }
        }
    }

    private void unsafeUpdateTEDataFromSchematic(TileEntityColonyBuilding te) {
        String packName;
        String structureName;
        if (te.getSchematicName().isEmpty()) {
            structureName = this.path;
            packName = this.structurePack;
        } else {
            structureName = te.getBlueprintPath();
            packName = te.getStructurePack().getName();
        }
        this.blueprintFuture = StructurePacks.getBlueprintFuture((String)packName, (String)structureName, (HolderLookup.Provider)te.getLevel().registryAccess());
        this.blueprintFuturePack = packName;
        this.blueprintFutureName = structureName;
    }

    @Override
    public String getStructurePack() {
        IBuilding building;
        BlockPos parent = this.getParent();
        if (parent != BlockPos.ZERO && (building = this.colony.getBuildingManager().getBuilding(parent)) != null) {
            return building.getStructurePack();
        }
        return this.structurePack;
    }

    @Override
    public void setStructurePack(String pack) {
        this.structurePack = pack;
        this.markDirty();
        this.getTileEntity().setStructurePack(StructurePacks.getStructurePack((String)pack));
    }

    @Override
    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    @Override
    public void setBuildingLevel(int level) {
        if (level > this.getMaxBuildingLevel()) {
            return;
        }
        this.isDeconstructed = false;
        this.buildingLevel = level;
        this.markDirty();
    }

    @Override
    public void setRotationMirror(RotationMirror rotMir) {
        this.rotationMirror = rotMir;
    }

    @Override
    public RotationMirror getRotationMirror() {
        return this.rotationMirror;
    }

    @Override
    public boolean isInBuilding(@NotNull BlockPos positionVec) {
        Tuple<BlockPos, BlockPos> corners = this.getCorners();
        BlockPos cornerA = (BlockPos)corners.getA();
        BlockPos cornerB = (BlockPos)corners.getB();
        if (this.hasModule(IAltersBuildingFootprint.class)) {
            Tuple<BlockPos, BlockPos> extensions = ((IAltersBuildingFootprint)this.getFirstModuleOccurance(IAltersBuildingFootprint.class)).getAdditionalCorners();
            cornerA = cornerA.offset((Vec3i)extensions.getA());
            cornerB = cornerB.offset((Vec3i)extensions.getB());
        }
        return positionVec.getX() >= cornerA.getX() - 1 && positionVec.getX() <= cornerB.getX() + 1 && positionVec.getY() >= cornerA.getY() - 1 && positionVec.getY() <= cornerB.getY() + 1 && positionVec.getZ() >= cornerA.getZ() - 1 && positionVec.getZ() <= cornerB.getZ() + 1;
    }

    @Override
    public void upgradeBuildingLevelToSchematicData() {
        BlockEntity tileEntity = this.colony.getWorld().getBlockEntity(this.getID());
        if (tileEntity instanceof IBlueprintDataProviderBE) {
            IBlueprintDataProviderBE blueprintDataProvider = (IBlueprintDataProviderBE)tileEntity;
            if (blueprintDataProvider.getSchematicName().isEmpty()) {
                return;
            }
            this.setCorners((BlockPos)blueprintDataProvider.getInWorldCorners().getA(), (BlockPos)blueprintDataProvider.getInWorldCorners().getB());
            int level = 0;
            try {
                level = Integer.parseInt(blueprintDataProvider.getSchematicName().substring(blueprintDataProvider.getSchematicName().length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (level > 0 && (level > this.getBuildingLevel() || this.isDeconstructed) && level <= this.getMaxBuildingLevel()) {
                if (level > this.getBuildingLevel()) {
                    BlockEntity parentTileEntity;
                    Tuple<BlockPos, BlockPos> corners = this.getCorners();
                    if (this.getParent() != BlockPos.ZERO && (parentTileEntity = this.colony.getWorld().getBlockEntity(this.getParent())) instanceof AbstractTileEntityColonyBuilding) {
                        AbstractTileEntityColonyBuilding parentBuildingTileEntity = (AbstractTileEntityColonyBuilding)parentTileEntity;
                        corners = parentBuildingTileEntity.getBuilding().getCorners();
                    }
                    FireworkUtils.spawnFireworksAtAABBCorners(corners, this.colony.getWorld(), level);
                }
                this.setBuildingLevel(level);
                this.onUpgradeComplete(level);
                this.isDeconstructed = false;
            }
        }
    }

    @Override
    public void onUpgradeSchematicTo(String oldSchematic, String newSchematic, IBlueprintDataProviderBE blueprintDataProvider) {
        this.upgradeBuildingLevelToSchematicData();
    }

    @Override
    public final BuildingEntry getBuildingType() {
        return this.buildingType;
    }

    @Override
    public void setBuildingType(BuildingEntry buildingType) {
        this.buildingType = buildingType;
    }
}

