/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildingextensions.registry;

import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildingextensions.registry.BuildingExtensionRegistries;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public final class BuildingExtensionDataManager {
    private static final String TAG_EXTENSION_NAME = "name";
    private static final String TAG_EXTENSION_POSITION = "position";
    private static final String TAG_EXTENSION_DATA = "data";

    private BuildingExtensionDataManager() {
    }

    public static IBuildingExtension compoundToExtension(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        BlockPos position;
        ResourceLocation name = ResourceLocation.parse((String)compound.getString(TAG_EXTENSION_NAME));
        IBuildingExtension extension = BuildingExtensionDataManager.resourceLocationToExtension(name, position = BlockPosUtil.read(compound, TAG_EXTENSION_POSITION));
        if (extension != null) {
            extension.deserializeNBT(provider, compound.getCompound(TAG_EXTENSION_DATA));
        }
        return extension;
    }

    public static IBuildingExtension resourceLocationToExtension(@NotNull ResourceLocation registryName, @NotNull BlockPos position) {
        BuildingExtensionRegistries.BuildingExtensionEntry entry = (BuildingExtensionRegistries.BuildingExtensionEntry)BuildingExtensionRegistries.getBuildingExtensionRegistry().get(registryName);
        if (entry == null) {
            Log.getLogger().error("Unknown building extension type '{}'.", (Object)registryName);
            return null;
        }
        return entry.produceExtension(position);
    }

    public static IBuildingExtension bufferToExtension(@NotNull RegistryFriendlyByteBuf buf) {
        BuildingExtensionRegistries.BuildingExtensionEntry entry = (BuildingExtensionRegistries.BuildingExtensionEntry)buf.readById(arg_0 -> BuildingExtensionRegistries.getBuildingExtensionRegistry().byIdOrThrow(arg_0));
        BlockPos position = buf.readBlockPos();
        IBuildingExtension extension = entry.produceExtension(position);
        extension.deserialize(buf);
        return extension;
    }

    public static RegistryFriendlyByteBuf extensionToBuffer(@NotNull IBuildingExtension extension, @NotNull RegistryAccess provider) {
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), provider);
        buf.writeById(arg_0 -> BuildingExtensionRegistries.getBuildingExtensionRegistry().getIdOrThrow(arg_0), (Object)extension.getBuildingExtensionType());
        buf.writeBlockPos(extension.getPosition());
        extension.serialize(buf);
        return buf;
    }

    public static CompoundTag extensionToCompound(@NotNull HolderLookup.Provider provider, @NotNull IBuildingExtension extension) {
        CompoundTag compound = new CompoundTag();
        compound.putString(TAG_EXTENSION_NAME, extension.getBuildingExtensionType().getRegistryName().toString());
        BlockPosUtil.write(compound, TAG_EXTENSION_POSITION, extension.getPosition());
        compound.put(TAG_EXTENSION_DATA, (Tag)extension.serializeNBT(provider));
        return compound;
    }
}

