/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony;

import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.minecolonies.api.colony.CitizenNameFile;
import com.minecolonies.api.colony.ColonyState;
import com.minecolonies.api.colony.ICitizenDataManager;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorViewData;
import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildings.registry.IBuildingDataManager;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.colony.claim.ChunkClaimData;
import com.minecolonies.api.colony.connections.IColonyConnectionManager;
import com.minecolonies.api.colony.managers.interfaces.ICitizenManager;
import com.minecolonies.api.colony.managers.interfaces.IColonyPackageManager;
import com.minecolonies.api.colony.managers.interfaces.IEventDescriptionManager;
import com.minecolonies.api.colony.managers.interfaces.IEventManager;
import com.minecolonies.api.colony.managers.interfaces.IGraveManager;
import com.minecolonies.api.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.api.colony.managers.interfaces.IRegisteredStructureManager;
import com.minecolonies.api.colony.managers.interfaces.IReproductionManager;
import com.minecolonies.api.colony.managers.interfaces.IStatisticsManager;
import com.minecolonies.api.colony.managers.interfaces.ITravellingManager;
import com.minecolonies.api.colony.managers.interfaces.IVisitorManager;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.quests.IQuestManager;
import com.minecolonies.api.research.IResearchManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.client.render.worldevent.ColonyBlueprintRenderer;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.GraveManagerView;
import com.minecolonies.core.colony.VisitorDataView;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.core.colony.managers.ColonyConnectionManager;
import com.minecolonies.core.colony.managers.ResearchManager;
import com.minecolonies.core.colony.managers.StatisticsManager;
import com.minecolonies.core.colony.managers.TravellingManager;
import com.minecolonies.core.colony.permissions.PermissionsView;
import com.minecolonies.core.colony.requestsystem.management.manager.StandardRequestManager;
import com.minecolonies.core.colony.workorders.AbstractWorkOrder;
import com.minecolonies.core.datalistener.CitizenNameListener;
import com.minecolonies.core.network.messages.PermissionsMessage;
import com.minecolonies.core.network.messages.server.colony.ColonyFlagChangeMessage;
import com.minecolonies.core.network.messages.server.colony.TownHallRenameMessage;
import com.minecolonies.core.quests.QuestManager;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColonyView
implements IColonyView {
    private static final int REQUEST_MANAGER_MAX_SIZE = 700000;
    private final int id;
    private final Map<Integer, IWorkOrderView> workOrders = new HashMap<Integer, IWorkOrderView>();
    private final Map<Integer, BlockPos> workOrderClaimCache = new HashMap<Integer, BlockPos>();
    private int workOrderCachedCount;
    @NotNull
    private final PermissionsView permissions = new PermissionsView();
    @NotNull
    private final Map<BlockPos, IBuildingView> buildings = new HashMap<BlockPos, IBuildingView>();
    @NotNull
    private final Set<IBuildingExtension> extensions = new HashSet<IBuildingExtension>();
    @NotNull
    private final Map<Integer, ICitizenDataView> citizens = new HashMap<Integer, ICitizenDataView>();
    private Map<Integer, IVisitorViewData> visitors = new HashMap<Integer, IVisitorViewData>();
    private String name = "Unknown";
    private ResourceKey<Level> dimensionId;
    private ChatFormatting teamColonyColor = ChatFormatting.WHITE;
    private BannerPatternLayers colonyFlag;
    private BlockPos center = BlockPos.ZERO;
    @Nullable
    private ITownHallView townHall;
    private int citizenCount = 0;
    private int citizenCountWithEmptyGuardTowers = 0;
    private boolean hasColonyWarehouse;
    private final List<BlockPos> lastSpawnPoints = new ArrayList<BlockPos>();
    private final Set<BlockPos> freePositions = new HashSet<BlockPos>();
    private final Set<Block> freeBlocks = new HashSet<Block>();
    private final Map<BlockPos, BlockState> wayPoints = new HashMap<BlockPos, BlockState>();
    private double overallHappiness = 5.0;
    private int lastContactInHours = 0;
    private IRequestManager requestManager;
    private boolean isUnderRaid;
    private final ResourceKey<Level> world;
    private boolean printProgress;
    private long mercenaryLastUseTime = 0L;
    private String style = "";
    private final IResearchManager researchManager;
    private boolean spiesEnabled;
    private Set<Long> ticketedChunks = new HashSet<Long>();
    private String textureStyle;
    private final IGraveManager graveManager = new GraveManagerView();
    private final List<String> nameFileIds = new ArrayList<String>();
    private String nameStyle;
    private final IStatisticsManager statisticManager = new StatisticsManager();
    private final IQuestManager questManager;
    private final TravellingManager travellingManager = new TravellingManager(this);
    private final IColonyConnectionManager connectionManager = new ColonyConnectionManager(this);
    private int day;

    private ColonyView(int id, ResourceKey<Level> dim) {
        this.id = id;
        this.world = dim;
        this.researchManager = new ResearchManager(this);
        this.questManager = new QuestManager(this);
    }

    @NotNull
    public static ColonyView createFromNetwork(int id, ResourceKey<Level> dim) {
        return new ColonyView(id, dim);
    }

    public static void serializeNetworkData(@NotNull Colony colony, @NotNull RegistryFriendlyByteBuf buf, boolean hasNewSubscribers) {
        buf.writeUtf(colony.getName());
        buf.writeUtf(colony.getDimension().location().toString());
        buf.writeBlockPos(colony.getCenter());
        buf.writeInt(colony.getCitizenManager().getMaxCitizens());
        buf.writeInt(colony.getCitizenManager().getPotentialMaxCitizens());
        Set<Block> freeBlocks = colony.getFreeBlocks();
        Set<BlockPos> freePos = colony.getFreePositions();
        Map<BlockPos, BlockState> waypoints = colony.getWayPoints();
        buf.writeInt(freeBlocks.size());
        for (Block block : freeBlocks) {
            buf.writeUtf(BuiltInRegistries.BLOCK.getKey((Object)block).toString());
        }
        buf.writeInt(freePos.size());
        for (BlockPos blockPos : freePos) {
            buf.writeBlockPos(blockPos);
        }
        buf.writeDouble(colony.getOverallHappiness());
        buf.writeBoolean(colony.hasWarehouse());
        buf.writeInt(waypoints.size());
        for (Map.Entry entry : waypoints.entrySet()) {
            buf.writeBlockPos((BlockPos)entry.getKey());
            buf.writeInt(Block.getId((BlockState)((BlockState)entry.getValue())));
        }
        buf.writeInt(colony.getLastContactInHours());
        buf.writeUtf(colony.getTextureStyleId());
        buf.writeUtf(colony.getNameStyle());
        buf.writeInt(CitizenNameListener.nameFileMap.size());
        for (String string : CitizenNameListener.nameFileMap.keySet()) {
            buf.writeUtf(string);
        }
        if (colony.getRequestManager() != null && (colony.getRequestManager().isDirty() || hasNewSubscribers)) {
            int preIndex = buf.writerIndex();
            try {
                buf.writeBoolean(true);
                colony.getRequestManager().serialize(StandardFactoryController.getInstance(), buf);
                int n = buf.writerIndex();
                if (n - preIndex >= 700000) {
                    Log.getLogger().warn("Colony " + colony.getID() + " has a very big memory imprint, this could be a memory leak, please contact the mod author!");
                }
            }
            catch (Exception exception) {
                buf.writerIndex(preIndex);
                Log.getLogger().warn("Error during request manager serialization for:" + colony.getID(), (Throwable)exception);
                colony.getRequestManager().reset();
                buf.writeBoolean(false);
            }
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(colony.getRaiderManager().getLastSpawnPoints().size());
        for (BlockPos blockPos : colony.getRaiderManager().getLastSpawnPoints()) {
            buf.writeBlockPos(blockPos);
        }
        buf.writeInt(colony.getTeamColonyColor().ordinal());
        Utils.serializeCodecMess(BannerPatternLayers.STREAM_CODEC, buf, colony.getColonyFlag());
        buf.writeLong(colony.getMercenaryUseTime());
        buf.writeUtf(colony.getStructurePack());
        buf.writeBoolean(colony.getRaiderManager().isRaided());
        buf.writeBoolean(colony.getRaiderManager().areSpiesEnabled());
        if (hasNewSubscribers || colony.isTicketedChunksDirty()) {
            buf.writeInt(colony.getTicketedChunks().size());
            Iterator<Object> preIndex = colony.getTicketedChunks().iterator();
            while (preIndex.hasNext()) {
                long l = (Long)preIndex.next();
                buf.writeLong(l);
            }
        } else {
            buf.writeInt(-1);
        }
        Long2ObjectMap<ChunkClaimData> colonyClaimData = colony.getClaimData();
        buf.writeInt(colonyClaimData.size());
        for (Long2ObjectMap.Entry entry : colonyClaimData.long2ObjectEntrySet()) {
            buf.writeLong(entry.getLongKey());
            buf.writeNbt((Tag)((ChunkClaimData)entry.getValue()).serializeNBT((HolderLookup.Provider)buf.registryAccess()));
        }
        CompoundTag compoundTag = new CompoundTag();
        colony.getGraveManager().write(compoundTag);
        buf.writeNbt((Tag)compoundTag);
        colony.getStatisticsManager().serialize(buf, hasNewSubscribers);
        colony.getQuestManager().serialize(buf, hasNewSubscribers);
        buf.writeInt(colony.getDay());
        buf.writeNbt((Tag)colony.getTravellingManager().serializeNBT((HolderLookup.Provider)buf.registryAccess()));
        colony.getConnectionManager().serializeToView((FriendlyByteBuf)buf);
    }

    @Override
    public List<BlockPos> getFreePositions() {
        return new ArrayList<BlockPos>(this.freePositions);
    }

    @Override
    public List<Block> getFreeBlocks() {
        return new ArrayList<Block>(this.freeBlocks);
    }

    @Override
    public void addFreePosition(@NotNull BlockPos pos) {
        this.freePositions.add(pos);
    }

    @Override
    public void addFreeBlock(@NotNull Block block) {
        this.freeBlocks.add(block);
    }

    @Override
    public void removeFreePosition(@NotNull BlockPos pos) {
        this.freePositions.remove(pos);
    }

    @Override
    public void removeFreeBlock(@NotNull Block block) {
        this.freeBlocks.remove(block);
    }

    @Override
    public void setCanBeAutoDeleted(boolean canBeDeleted) {
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.dimensionId;
    }

    @Override
    public boolean isManualHiring() {
        return this.townHall != null && this.townHall.getModuleView(BuildingModules.TOWNHALL_SETTINGS).getSetting(BuildingTownHall.AUTO_HIRING_MODE).getValue() == false;
    }

    @Override
    public CompoundTag write(CompoundTag colonyCompound, HolderLookup.Provider provider) {
        return new CompoundTag();
    }

    @Override
    public void read(CompoundTag compound, HolderLookup.Provider provider) {
    }

    @Override
    public boolean isManualHousing() {
        return this.townHall != null && this.townHall.getModuleView(BuildingModules.TOWNHALL_SETTINGS).getSetting(BuildingTownHall.AUTO_HOUSING_MODE).getValue() == false;
    }

    @Override
    public void addWayPoint(BlockPos pos, BlockState newWayPointState) {
    }

    @Override
    public boolean isValidAttackingGuard(AbstractEntityCitizen entity) {
        return false;
    }

    @Override
    public boolean canMoveIn() {
        return this.townHall != null && this.townHall.getModuleView(BuildingModules.TOWNHALL_SETTINGS).getSetting(BuildingTownHall.MOVE_IN).getValue() == false;
    }

    @Override
    public boolean useAdditionalChildTime(int amount) {
        return false;
    }

    @Override
    public void updateHasChilds() {
    }

    @Override
    public void addLoadedChunk(long chunkPos, LevelChunk chunk) {
    }

    @Override
    public void removeLoadedChunk(long chunkPos) {
    }

    @Override
    public int getLoadedChunkCount() {
        return 0;
    }

    @Override
    public Set<Long> getLoadedChunks() {
        return null;
    }

    @Override
    public ColonyState getState() {
        return null;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public Set<Long> getTicketedChunks() {
        return this.ticketedChunks;
    }

    @Override
    public void setTextureStyle(String style) {
        this.textureStyle = style;
    }

    @Override
    public String getTextureStyleId() {
        return this.textureStyle;
    }

    @Override
    @Nullable
    public ITownHallView getTownHall() {
        return this.townHall;
    }

    @Override
    public IBuildingView getBuilding(int x, int y, int z) {
        return this.getBuilding(new BlockPos(x, y, z));
    }

    @Override
    public IBuildingView getBuilding(BlockPos buildingId) {
        return this.buildings.get(buildingId);
    }

    @Override
    @NotNull
    public Map<UUID, ColonyPlayer> getPlayers() {
        return this.permissions.getPlayers();
    }

    @Override
    public int getCitizenCount() {
        return this.citizenCount;
    }

    @Override
    public int getCitizenCountLimit() {
        return this.citizenCountWithEmptyGuardTowers;
    }

    @Override
    public Map<Integer, ICitizenDataView> getCitizens() {
        return Collections.unmodifiableMap(this.citizens);
    }

    @Override
    public Collection<IWorkOrderView> getWorkOrders() {
        return Collections.unmodifiableCollection(this.workOrders.values());
    }

    @Override
    public IWorkOrderView getWorkOrder(int id) {
        return this.workOrders.get(id);
    }

    @Override
    public ICitizenDataView getCitizen(int id) {
        if (id > 0) {
            return this.citizens.get(id);
        }
        return this.visitors.get(id);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleColonyViewMessage(@NotNull RegistryFriendlyByteBuf buf, boolean isNewSubscription) {
        this.colonyFlag = new BannerPatternLayers.Builder().add(Utils.getRegistryValue(BannerPatterns.BASE, this.getWorld()), DyeColor.WHITE).build();
        this.name = buf.readUtf(Short.MAX_VALUE);
        this.dimensionId = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)buf.readUtf(Short.MAX_VALUE)));
        this.center = buf.readBlockPos();
        this.citizenCount = buf.readInt();
        this.citizenCountWithEmptyGuardTowers = buf.readInt();
        if (isNewSubscription) {
            this.citizens.clear();
            this.townHall = null;
            this.buildings.clear();
        }
        this.freePositions.clear();
        this.freeBlocks.clear();
        this.wayPoints.clear();
        this.lastSpawnPoints.clear();
        this.nameFileIds.clear();
        int blockListSize = buf.readInt();
        for (int i = 0; i < blockListSize; ++i) {
            this.freeBlocks.add((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)buf.readUtf(Short.MAX_VALUE))));
        }
        int posListSize = buf.readInt();
        for (int i = 0; i < posListSize; ++i) {
            this.freePositions.add(buf.readBlockPos());
        }
        this.overallHappiness = buf.readDouble();
        this.hasColonyWarehouse = buf.readBoolean();
        int wayPointListSize = buf.readInt();
        for (int i = 0; i < wayPointListSize; ++i) {
            this.wayPoints.put(buf.readBlockPos(), Block.stateById((int)buf.readInt()));
        }
        this.lastContactInHours = buf.readInt();
        this.textureStyle = buf.readUtf(Short.MAX_VALUE);
        this.nameStyle = buf.readUtf(Short.MAX_VALUE);
        int nameFileIdSize = buf.readInt();
        for (int i = 0; i < nameFileIdSize; ++i) {
            this.nameFileIds.add(buf.readUtf(Short.MAX_VALUE));
        }
        if (buf.readBoolean()) {
            if (this.requestManager == null) {
                this.requestManager = new StandardRequestManager(this);
            }
            this.requestManager.deserialize(StandardFactoryController.getInstance(), buf);
        }
        int barbSpawnListSize = buf.readInt();
        for (int i = 0; i < barbSpawnListSize; ++i) {
            this.lastSpawnPoints.add(buf.readBlockPos());
        }
        Collections.reverse(this.lastSpawnPoints);
        this.teamColonyColor = ChatFormatting.values()[buf.readInt()];
        this.colonyFlag = (BannerPatternLayers)Utils.deserializeCodecMess(BannerPatternLayers.STREAM_CODEC, buf);
        this.mercenaryLastUseTime = buf.readLong();
        this.style = buf.readUtf(Short.MAX_VALUE);
        if (isNewSubscription && StructurePacks.hasPack((String)this.style) && RenderingCache.getOrCreateBlueprintPreviewData((String)"blueprint").getBlueprint() == null && Minecraft.getInstance().player != null && this.isCoordInColony(this.getWorld(), Minecraft.getInstance().player.blockPosition())) {
            StructurePacks.selectedPack = StructurePacks.getStructurePack((String)this.style);
        }
        this.isUnderRaid = buf.readBoolean();
        this.spiesEnabled = buf.readBoolean();
        int ticketChunkCount = buf.readInt();
        if (ticketChunkCount != -1) {
            this.ticketedChunks = new HashSet<Long>(ticketChunkCount);
            for (int i = 0; i < ticketChunkCount; ++i) {
                this.ticketedChunks.add(buf.readLong());
            }
        }
        Long2ObjectOpenHashMap colonyClaimData = new Long2ObjectOpenHashMap();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ChunkClaimData chunkClaimData = new ChunkClaimData();
            long pos = buf.readLong();
            chunkClaimData.deserializeNBT((HolderLookup.Provider)buf.registryAccess(), buf.readNbt());
            colonyClaimData.put(pos, (Object)chunkClaimData);
        }
        if (Minecraft.getInstance().getSingleplayerServer() == null) {
            IColonyManager.getInstance().addClaimData(this, (Long2ObjectMap<ChunkClaimData>)colonyClaimData);
        }
        this.graveManager.read(buf.readNbt());
        this.statisticManager.deserialize(buf);
        this.questManager.deserialize(buf);
        this.day = buf.readInt();
        this.travellingManager.deserializeNBT((HolderLookup.Provider)buf.registryAccess(), buf.readNbt());
        this.connectionManager.deserializeFromView((FriendlyByteBuf)buf);
    }

    @Override
    public void handlePermissionsViewMessage(@NotNull RegistryFriendlyByteBuf buf) {
        this.permissions.deserialize(buf);
    }

    @Override
    public void handleColonyViewWorkOrderMessage(RegistryFriendlyByteBuf buf) {
        boolean claimsChanged = false;
        this.workOrders.clear();
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            @Nullable IWorkOrderView workOrder = AbstractWorkOrder.createWorkOrderView(buf);
            if (workOrder == null) continue;
            workOrder.setColony(this);
            this.workOrders.put(workOrder.getID(), workOrder);
            BlockPos oldClaimedBy = this.workOrderClaimCache.put(workOrder.getID(), workOrder.getClaimedBy());
            claimsChanged |= !Objects.equals(workOrder.getClaimedBy(), oldClaimedBy);
        }
        if (claimsChanged || this.workOrders.size() != this.workOrderCachedCount) {
            this.workOrderCachedCount = this.workOrders.size();
            ColonyBlueprintRenderer.invalidateCache();
        }
    }

    @Override
    public void handleColonyViewCitizensMessage(int id, RegistryFriendlyByteBuf buf) {
        ICitizenDataView citizen = ICitizenDataManager.getInstance().createFromNetworkData(id, buf, this);
        if (citizen != null) {
            this.citizens.put(citizen.getId(), citizen);
        }
    }

    @Override
    public void handleColonyViewVisitorMessage(RegistryFriendlyByteBuf visitorBuf, boolean refresh) {
        HashMap<Integer, IVisitorViewData> visitorCache = new HashMap<Integer, IVisitorViewData>(this.visitors);
        if (refresh) {
            this.visitors.clear();
        }
        int i = visitorBuf.readInt();
        for (int j = 0; j < i; ++j) {
            int id = visitorBuf.readInt();
            IVisitorViewData dataView = visitorCache.containsKey(id) ? (IVisitorViewData)visitorCache.get(id) : new VisitorDataView(id, this);
            dataView.deserialize(visitorBuf);
            this.visitors.put(dataView.getId(), dataView);
        }
    }

    @Override
    public void handleColonyViewRemoveCitizenMessage(int citizen) {
        this.citizens.remove(citizen);
    }

    @Override
    public void handleColonyViewRemoveBuildingMessage(BlockPos buildingId) {
        IBuildingView building = this.buildings.remove(buildingId);
        if (this.townHall == building) {
            this.townHall = null;
        }
    }

    @Override
    public void handleColonyViewRemoveWorkOrderMessage(int workOrderId) {
        this.workOrders.remove(workOrderId);
    }

    @Override
    public void handleColonyBuildingViewMessage(BlockPos buildingId, @NotNull RegistryFriendlyByteBuf buf) {
        if (this.buildings.containsKey(buildingId)) {
            buf.readUtf(Short.MAX_VALUE);
            this.buildings.get(buildingId).deserialize(buf);
        } else {
            @Nullable IBuildingView building = IBuildingDataManager.getInstance().createViewFrom(this, buildingId, buf);
            if (building != null) {
                this.buildings.put(building.getID(), building);
                if (building instanceof BuildingTownHall.View) {
                    this.townHall = (ITownHallView)building;
                }
            }
        }
    }

    @Override
    public void handleColonyViewResearchManagerUpdate(@NotNull HolderLookup.Provider provider, CompoundTag compoundTag) {
        this.researchManager.readFromNBT(provider, compoundTag);
    }

    @Override
    public void handleColonyBuildingExtensionsViewUpdateMessage(Set<IBuildingExtension> extensions) {
        this.extensions.clear();
        this.extensions.addAll(extensions);
    }

    @Override
    @NotNull
    public List<IBuildingExtension> getBuildingExtensions(Predicate<IBuildingExtension> matcher) {
        return this.extensions.stream().filter(matcher).toList();
    }

    @Override
    @Nullable
    public IBuildingExtension getBuildingExtension(Predicate<IBuildingExtension> matcher) {
        return this.getBuildingExtensions(matcher).stream().findFirst().orElse(null);
    }

    @Override
    public void addPlayer(String player) {
        new PermissionsMessage.AddPlayer(this, player).sendToServer();
    }

    @Override
    public void removePlayer(UUID player) {
        new PermissionsMessage.RemovePlayer(this, player).sendToServer();
    }

    @Override
    public double getOverallHappiness() {
        return this.overallHappiness;
    }

    @Override
    public BlockPos getCenter() {
        return this.center;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ChatFormatting getTeamColonyColor() {
        return this.teamColonyColor;
    }

    @Override
    public BannerPatternLayers getColonyFlag() {
        return this.colonyFlag;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        new TownHallRenameMessage(this, name).sendToServer();
    }

    @Override
    @NotNull
    public IPermissions getPermissions() {
        return this.permissions;
    }

    @Override
    public boolean isCoordInColony(@NotNull Level w, @NotNull BlockPos pos) {
        LevelChunk chunk = w.getChunkAt(pos);
        return ColonyUtils.getOwningColony((ChunkAccess)chunk) == this.getID();
    }

    @Override
    public long getDistanceSquared(@NotNull BlockPos pos) {
        return BlockPosUtil.getDistanceSquared2D(this.center, pos);
    }

    @Override
    public boolean hasTownHall() {
        return this.townHall != null;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public boolean hasWarehouse() {
        return this.hasColonyWarehouse;
    }

    @Override
    public boolean hasBuilding(ResourceLocation name, int level, boolean singleBuilding) {
        int sum = 0;
        for (IBuildingView building : this.buildings.values()) {
            if (!building.getBuildingType().getRegistryName().equals((Object)name) || !(singleBuilding ? building.getBuildingLevel() >= level : (sum += building.getBuildingLevel()) >= level)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDay() {
        return false;
    }

    @Override
    public int getLastContactInHours() {
        return this.lastContactInHours;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Level getWorld() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null || !level.dimension().equals(this.world)) {
            throw new IllegalStateException("Cannot get colony view level");
        }
        return level;
    }

    @Override
    @NotNull
    public IRequestManager getRequestManager() {
        return this.requestManager;
    }

    @Override
    public void markDirty() {
    }

    @Override
    public boolean canBeAutoDeleted() {
        return false;
    }

    @Override
    @Nullable
    public IRequester getRequesterBuildingForPosition(@NotNull BlockPos pos) {
        return this.getBuilding(pos);
    }

    @Override
    public void removeVisitingPlayer(Player player) {
    }

    @Override
    @NotNull
    public List<Player> getMessagePlayerEntities() {
        return new ArrayList<Player>();
    }

    @Override
    public void addVisitingPlayer(Player player) {
    }

    @Override
    public void onWorldLoad(ServerLevel w) {
    }

    @Override
    public void onWorldUnload(@NotNull Level w) {
    }

    @Override
    public void onServerTick(@NotNull ServerTickEvent.Pre event) {
    }

    @Override
    @NotNull
    public IWorkManager getWorkManager() {
        return null;
    }

    @Override
    public void onWorldTick(@NotNull LevelTickEvent.Pre event) {
    }

    @Override
    public Map<BlockPos, BlockState> getWayPoints() {
        return this.wayPoints;
    }

    @Override
    public List<BlockPos> getLastSpawnPoints() {
        return new ArrayList<BlockPos>(this.lastSpawnPoints);
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public CompoundTag getColonyTag() {
        return null;
    }

    @Override
    public boolean isColonyUnderAttack() {
        return false;
    }

    @Override
    public boolean isValidAttackingPlayer(Player entity) {
        return false;
    }

    @Override
    public void addGuardToAttackers(AbstractEntityCitizen entityCitizen, Player followPlayer) {
    }

    @Override
    public void setColonyColor(ChatFormatting color) {
    }

    @Override
    public void setColonyFlag(BannerPatternLayers colonyFlag) {
        this.colonyFlag = colonyFlag;
        new ColonyFlagChangeMessage(this, colonyFlag).sendToServer();
    }

    @Override
    public List<IBuildingView> getBuildings() {
        return new ArrayList<IBuildingView>(this.buildings.values());
    }

    @Override
    @NotNull
    public List<Player> getImportantMessageEntityPlayers() {
        return new ArrayList<Player>();
    }

    @Override
    public String getStructurePack() {
        return this.style;
    }

    @Override
    public void setStructurePack(String style) {
        this.style = style;
    }

    @Override
    public IRegisteredStructureManager getBuildingManager() {
        return null;
    }

    @Override
    public IGraveManager getGraveManager() {
        return this.graveManager;
    }

    @Override
    public ICitizenManager getCitizenManager() {
        return null;
    }

    @Override
    public IVisitorManager getVisitorManager() {
        return null;
    }

    @Override
    public IRaiderManager getRaiderManager() {
        return null;
    }

    @Override
    public IEventManager getEventManager() {
        return null;
    }

    @Override
    public IReproductionManager getReproductionManager() {
        return null;
    }

    @Override
    public IEventDescriptionManager getEventDescriptionManager() {
        return null;
    }

    @Override
    public IColonyPackageManager getPackageManager() {
        return null;
    }

    @Override
    public ITravellingManager getTravellingManager() {
        return this.travellingManager;
    }

    @Override
    public IColonyConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public boolean isRaiding() {
        return this.isUnderRaid;
    }

    @Override
    public long getMercenaryUseTime() {
        return this.mercenaryLastUseTime;
    }

    @Override
    public void usedMercenaries() {
        this.mercenaryLastUseTime = this.getWorld().getGameTime();
    }

    @Override
    public IResearchManager getResearchManager() {
        return this.researchManager;
    }

    @Override
    public boolean areSpiesEnabled() {
        return this.spiesEnabled;
    }

    @Override
    public ICitizenDataView getVisitor(int citizenId) {
        return this.visitors.get(citizenId);
    }

    @Override
    public void setNameStyle(String style) {
        this.nameStyle = style;
        this.markDirty();
    }

    @Override
    public String getNameStyle() {
        return this.nameStyle;
    }

    @Override
    public List<String> getNameFileIds() {
        return this.nameFileIds;
    }

    @Override
    public CitizenNameFile getCitizenNameFile() {
        return CitizenNameListener.nameFileMap.getOrDefault(this.nameStyle, CitizenNameListener.nameFileMap.get("default"));
    }

    @Override
    public IStatisticsManager getStatisticsManager() {
        return this.statisticManager;
    }

    @Override
    public int getDay() {
        return this.day;
    }

    @Override
    public IQuestManager getQuestManager() {
        return this.questManager;
    }
}

