/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.containers;

import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.inventory.container.ContainerCitizenInventory;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class WindowCitizenInventory
extends AbstractContainerScreen<ContainerCitizenInventory> {
    private static final ResourceLocation TEXT = new ResourceLocation("minecolonies", "textures/gui/citizen_container.png");
    private static final int TEXTURE_OFFSET = 130;
    private static final int SLOT_OFFSET = 18;
    private static final int TEXTURE_SIZE = 350;
    private static final int TEXTURE_HEIGHT = 96;
    private static final int Y_OFFSET = 114;
    private static final int SLOTS_EACH_ROW = 9;
    public static WindowCitizenInventory activeCitizenInventory = null;
    private ICitizen citizenData;
    private final int inventoryRows;

    public WindowCitizenInventory(ContainerCitizenInventory container, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)container, playerInventory, iTextComponent);
        this.inventoryRows = (container.getItems().size() - 36) / 9;
        this.imageHeight = 114 + Math.min(9, this.inventoryRows) * 18;
        this.imageWidth = 245;
        activeCitizenInventory = this;
        this.citizenData = container.getCitizenData();
    }

    public void render(@NotNull GuiGraphics stack, int x, int y, float z) {
        super.render(stack, x, y, z);
        this.renderTooltip(stack, x, y);
    }

    protected void renderLabels(@NotNull GuiGraphics stack, int mouseX, int mouseY) {
        stack.drawString(this.font, ((ContainerCitizenInventory)this.menu).getDisplayName(), 80, 9, 0x404040, false);
        stack.drawString(this.font, this.playerInventoryTitle.getString(), 8, 25 + this.inventoryRows * 18, 0x404040, false);
    }

    protected void renderBg(@NotNull GuiGraphics stack, float partialTicks, int mouseX, int mouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        stack.blit(TEXT, i, j, 0.0f, 0.0f, this.imageWidth, 10 + this.inventoryRows * 18 + 12, 350, 350);
        stack.blit(TEXT, i, j + 10 + this.inventoryRows * 18 + 12, 0.0f, 130.0f, this.imageWidth, 96, 350, 350);
        stack.blit(TEXT, i + 172, j + 22, 0.0f, 227.0f, 49, 72, 350, 350);
        for (int index = 0; index < 4; ++index) {
            stack.blit(TEXT, i + 222, j + 22 + index * 18, 0.0f, 300.0f, 18, 18, 350, 350);
        }
        WindowCitizenInventory.renderEntityInInventoryFollowsMouse(stack, i + 197, j + 88, 30, (float)(i + 51) - (float)mouseX, (float)(j + 75 - 50) - (float)mouseY, ((ContainerCitizenInventory)this.menu).getEntity());
    }

    public static void renderEntityInInventoryFollowsMouse(GuiGraphics stack, int x, int y, int scale, float mouseX, float mouseY, Optional<? extends Entity> optionalEntity) {
        optionalEntity.ifPresent(entity -> {
            float relativeMouseX = (float)Math.atan(mouseX / 40.0f);
            float relativeMouseY = (float)Math.atan(mouseY / 40.0f);
            WindowCitizenInventory.renderEntityInInventoryFollowsAngle(stack, x, y, scale, relativeMouseX, relativeMouseY, (LivingEntity)entity);
        });
    }

    public static void renderEntityInInventoryFollowsAngle(GuiGraphics stack, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        float f = angleXComponent;
        float f1 = angleYComponent;
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = new Quaternionf().rotateX(f1 * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf1);
        float f2 = entity.yBodyRot;
        float f3 = entity.getYRot();
        float f4 = entity.getXRot();
        float f5 = entity.yHeadRotO;
        float f6 = entity.yHeadRot;
        entity.yBodyRot = 180.0f + f * 20.0f;
        entity.setYRot(180.0f + f * 40.0f);
        entity.setXRot(-f1 * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        WindowCitizenInventory.renderEntityInInventory(stack, x, y, scale, quaternionf, quaternionf1, entity);
        entity.yBodyRot = f2;
        entity.setYRot(f3);
        entity.setXRot(f4);
        entity.yHeadRotO = f5;
        entity.yHeadRot = f6;
    }

    public static void renderEntityInInventory(GuiGraphics stack, int x, int y, int scale, Quaternionf quaternionf, @Nullable Quaternionf quaternionf1, LivingEntity entity) {
        stack.pose().pushPose();
        stack.pose().translate((double)x, (double)y, 50.0);
        stack.pose().mulPose(new Matrix4f().scaling((float)scale, (float)scale, (float)(-scale)));
        stack.pose().mulPose(quaternionf);
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        if (quaternionf1 != null) {
            quaternionf1.conjugate();
            entityrenderdispatcher.overrideCameraOrientation(quaternionf1);
        }
        entityrenderdispatcher.setRenderShadow(false);
        RenderSystem.runAsFancy(() -> entityrenderdispatcher.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, stack.pose(), (MultiBufferSource)stack.bufferSource(), 0xF000F0));
        stack.flush();
        entityrenderdispatcher.setRenderShadow(true);
        stack.pose().popPose();
        Lighting.setupFor3DItems();
    }

    public void onClose() {
        activeCitizenInventory = null;
        super.onClose();
    }

    public ICitizen getCitizenData() {
        return this.citizenData;
    }
}

