/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.ButtonImage;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.IModuleWindow;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import java.util.Locale;
import java.util.Random;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public abstract class AbstractModuleWindow
extends AbstractWindowSkeleton
implements IModuleWindow {
    protected final IBuildingView buildingView;

    public AbstractModuleWindow(IBuildingView building, String res) {
        super(res);
        this.buildingView = building;
        Random random = new Random(building.getID().hashCode());
        int offset = 0;
        boolean anyVisible = false;
        for (IBuildingModuleView view : building.getAllModuleViews()) {
            if (!view.isPageVisible()) continue;
            anyVisible = true;
            break;
        }
        if (building.getAllModuleViews().size() > 0 && anyVisible) {
            ButtonImage image = new ButtonImage();
            image.setImage(new ResourceLocation("minecolonies", "textures/gui/modules/tab_side" + (random.nextInt(3) + 1) + ".png"));
            image.setPosition(-20, 10 + offset);
            image.setSize(32, 26);
            image.setID("background/modules/main");
            image.setHandler(button -> building.getWindow().open());
            ButtonImage iconImage = new ButtonImage();
            iconImage.setImage(new ResourceLocation("minecolonies", "textures/gui/modules/main.png"));
            iconImage.setID("modules/main");
            iconImage.setPosition(-15, 13 + offset);
            iconImage.setSize(20, 20);
            iconImage.setHandler(button -> building.getWindow().open());
            offset += image.getHeight() + 2;
            this.addChild((Pane)image);
            this.addChild((Pane)iconImage);
            PaneBuilders.tooltipBuilder().hoverPane((Pane)iconImage).build().setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.maintab", (Object[])new Object[0]));
        }
        for (IBuildingModuleView view : building.getAllModuleViews()) {
            if (!view.isPageVisible()) continue;
            ResourceLocation icon = view.getIconResourceLocation();
            ButtonImage image = new ButtonImage();
            image.setImage(new ResourceLocation("minecolonies", "textures/gui/modules/tab_side" + (random.nextInt(3) + 1) + ".png"));
            image.setPosition(-20, 10 + offset);
            image.setSize(32, 26);
            image.setID("background/" + icon.getPath());
            image.setHandler(button -> {
                this.mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
                view.getWindow().open();
            });
            ButtonImage iconImage = new ButtonImage();
            iconImage.setImage(icon);
            iconImage.setSize(20, 20);
            iconImage.setID(icon.getPath());
            iconImage.setPosition(-15, 13 + offset);
            iconImage.setHandler(button -> {
                this.mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
                view.getWindow().open();
            });
            offset += image.getHeight() + 2;
            this.addChild((Pane)image);
            this.addChild((Pane)iconImage);
            PaneBuilders.tooltipBuilder().hoverPane((Pane)iconImage).build().setText(Component.translatableEscape((String)view.getDesc().toLowerCase(Locale.US), (Object[])new Object[0]));
        }
    }
}

