/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class ChunkCapData {
    public final int x;
    public final int z;
    private final int owningColony;
    private final List<Integer> staticColonyClaim;
    private final Map<Integer, Set<BlockPos>> allClaimBuildings;

    public ChunkCapData(int x, int z) {
        this.x = x;
        this.z = z;
        this.owningColony = 0;
        this.staticColonyClaim = new ArrayList<Integer>();
        this.allClaimBuildings = new HashMap<Integer, Set<BlockPos>>();
    }

    public ChunkCapData(int x, int z, int owningColony, List<Integer> staticColonyClaim, @NotNull Map<Integer, Set<BlockPos>> allClaimingBuildings) {
        this.x = x;
        this.z = z;
        this.owningColony = owningColony;
        this.staticColonyClaim = staticColonyClaim;
        this.allClaimBuildings = allClaimingBuildings;
    }

    public void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.z);
        buf.writeInt(this.owningColony);
        buf.writeInt(this.staticColonyClaim.size());
        for (Integer id : this.staticColonyClaim) {
            buf.writeInt(id.intValue());
        }
    }

    public static ChunkCapData fromBytes(@NotNull RegistryFriendlyByteBuf buffer) {
        int x = buffer.readInt();
        int z = buffer.readInt();
        int owning = buffer.readInt();
        int size = buffer.readInt();
        ArrayList<Integer> closeColonies = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            closeColonies.add(buffer.readInt());
        }
        return new ChunkCapData(x, z, owning, closeColonies, new HashMap<Integer, Set<BlockPos>>());
    }

    public List<Integer> getStaticColonyClaim() {
        return this.staticColonyClaim;
    }

    public int getOwningColony() {
        return this.owningColony;
    }

    public Map<Integer, Set<BlockPos>> getAllClaimingBuildings() {
        return this.allClaimBuildings;
    }
}

