/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.sounds;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class SoundManager {
    private static final int MAX_CONCURRENT_SOUNDS = 5;
    private static final Map<UUID, Deque<TimedSound>> soundQueue = new HashMap<UUID, Deque<TimedSound>>();

    public static void tick() {
        if (soundQueue.isEmpty()) {
            return;
        }
        if (Minecraft.getInstance().level == null) {
            soundQueue.clear();
            return;
        }
        int playedSounds = 1;
        for (Map.Entry<UUID, Deque<TimedSound>> entries : soundQueue.entrySet()) {
            if (entries.getValue().isEmpty()) continue;
            TimedSound instance = entries.getValue().peek();
            if (instance.timeout <= 0) {
                Minecraft.getInstance().player.level().playSound((Player)Minecraft.getInstance().player, instance.pos, instance.soundEvent, instance.source, instance.volume, instance.pitch);
                instance.timeout = instance.length;
                --instance.repetitions;
                if (instance.repetitions < 0) {
                    entries.getValue().pop();
                }
            } else {
                --instance.timeout;
            }
            if (++playedSounds < 5) continue;
            break;
        }
    }

    public static void addToQueue(UUID uuid, SoundEvent soundEvent, SoundSource source, int repetitions, int length, BlockPos pos, float volume, float pitch) {
        Deque queue = soundQueue.computeIfAbsent(uuid, k -> new ArrayDeque());
        queue.add(new TimedSound(soundEvent, source, repetitions, length, pos, volume, pitch));
    }

    public static class TimedSound {
        final SoundEvent soundEvent;
        final SoundSource source;
        final int length;
        final BlockPos pos;
        final float volume;
        final float pitch;
        int repetitions;
        int timeout = 0;

        public TimedSound(SoundEvent soundEvent, SoundSource source, int repetitions, int length, BlockPos pos, float volume, float pitch) {
            this.soundEvent = soundEvent;
            this.source = source;
            this.repetitions = repetitions;
            this.length = length;
            this.pos = pos;
            this.volume = volume;
            this.pitch = pitch;
        }
    }
}

