/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.sounds;

import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.entity.mobs.RaiderType;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.sounds.MercenarySounds;
import com.minecolonies.api.sounds.RaidSounds;
import com.minecolonies.api.sounds.RaiderSounds;
import com.minecolonies.api.sounds.TavernSounds;
import com.minecolonies.api.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ModSoundEvents {
    public static final String CITIZEN_SOUND_EVENT_PREFIX = "citizen.";
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"minecolonies");
    public static Map<String, Map<EventType, List<Tuple<SoundEvent, SoundEvent>>>> CITIZEN_SOUND_EVENTS = new HashMap<String, Map<EventType, List<Tuple<SoundEvent, SoundEvent>>>>();
    public static SoundEvent SAW;

    private ModSoundEvents() {
    }

    public static SoundEvent getSoundID(String soundName) {
        return SoundEvent.createVariableRangeEvent((ResourceLocation)new ResourceLocation("minecolonies", soundName));
    }

    static {
        ArrayList<ResourceLocation> mainTypes = new ArrayList<ResourceLocation>(ModJobs.getJobs());
        mainTypes.remove(ModJobs.placeHolder.getId());
        mainTypes.add(new ResourceLocation("minecolonies", "unemployed"));
        mainTypes.add(new ResourceLocation("minecolonies", "visitor"));
        for (ResourceLocation job : mainTypes) {
            HashMap map = new HashMap();
            for (EventType event : EventType.values()) {
                ArrayList<Tuple<SoundEvent, SoundEvent>> individualSounds = new ArrayList<Tuple<SoundEvent, SoundEvent>>();
                for (int i = 1; i <= 4; ++i) {
                    SoundEvent maleSoundEvent = ModSoundEvents.getSoundID(CITIZEN_SOUND_EVENT_PREFIX + job.getPath() + ".male" + i + "." + event.getId());
                    SoundEvent femaleSoundEvent = ModSoundEvents.getSoundID(CITIZEN_SOUND_EVENT_PREFIX + job.getPath() + ".female" + i + "." + event.getId());
                    SOUND_EVENTS.register(maleSoundEvent.getLocation().getPath(), () -> maleSoundEvent);
                    SOUND_EVENTS.register(femaleSoundEvent.getLocation().getPath(), () -> femaleSoundEvent);
                    individualSounds.add(new Tuple<SoundEvent, SoundEvent>(maleSoundEvent, femaleSoundEvent));
                }
                map.put(event, individualSounds);
            }
            CITIZEN_SOUND_EVENTS.put(job.getPath(), map);
        }
        HashMap map = new HashMap();
        for (EventType eventType : EventType.values()) {
            ArrayList<Tuple<SoundEvent, SoundEvent>> individualSounds = new ArrayList<Tuple<SoundEvent, SoundEvent>>();
            for (int i = 1; i <= 2; ++i) {
                SoundEvent maleSoundEvent = ModSoundEvents.getSoundID("citizen.child.male" + i + "." + eventType.getId());
                SoundEvent femaleSoundEvent = ModSoundEvents.getSoundID("citizen.child.female" + i + "." + eventType.getId());
                individualSounds.add(new Tuple<SoundEvent, SoundEvent>(maleSoundEvent, femaleSoundEvent));
                individualSounds.add(new Tuple<SoundEvent, SoundEvent>(maleSoundEvent, femaleSoundEvent));
            }
            map.put(eventType, individualSounds);
        }
        CITIZEN_SOUND_EVENTS.put("child", map);
        SOUND_EVENTS.register(TavernSounds.tavernTheme.getLocation().getPath(), () -> TavernSounds.tavernTheme);
        for (Enum enum_ : RaiderType.values()) {
            SoundEvent raiderHurt = ModSoundEvents.getSoundID("mob." + enum_.name().toLowerCase(Locale.US) + ".hurt");
            SoundEvent raiderDeath = ModSoundEvents.getSoundID("mob." + enum_.name().toLowerCase(Locale.US) + ".death");
            SoundEvent raiderSay = ModSoundEvents.getSoundID("mob." + enum_.name().toLowerCase(Locale.US) + ".say");
            SOUND_EVENTS.register(raiderHurt.getLocation().getPath(), () -> raiderHurt);
            SOUND_EVENTS.register(raiderDeath.getLocation().getPath(), () -> raiderDeath);
            SOUND_EVENTS.register(raiderSay.getLocation().getPath(), () -> raiderSay);
            HashMap<RaiderSounds.RaiderSoundTypes, SoundEvent> sounds = new HashMap<RaiderSounds.RaiderSoundTypes, SoundEvent>();
            sounds.put(RaiderSounds.RaiderSoundTypes.HURT, raiderHurt);
            sounds.put(RaiderSounds.RaiderSoundTypes.DEATH, raiderDeath);
            sounds.put(RaiderSounds.RaiderSoundTypes.SAY, raiderSay);
            RaiderSounds.raiderSounds.put((RaiderType)enum_, sounds);
        }
        SAW = ModSoundEvents.getSoundID("tile.sawmill.saw");
        SOUND_EVENTS.register(SAW.getLocation().getPath(), () -> SAW);
        SOUND_EVENTS.register(RaidSounds.WARNING.getLocation().getPath(), () -> RaidSounds.WARNING);
        SOUND_EVENTS.register(RaidSounds.WARNING_EARLY.getLocation().getPath(), () -> RaidSounds.WARNING_EARLY);
        SOUND_EVENTS.register(RaidSounds.VICTORY.getLocation().getPath(), () -> RaidSounds.VICTORY);
        SOUND_EVENTS.register(RaidSounds.VICTORY_EARLY.getLocation().getPath(), () -> RaidSounds.VICTORY_EARLY);
        SOUND_EVENTS.register(RaidSounds.AMAZON_RAID.getLocation().getPath(), () -> RaidSounds.AMAZON_RAID);
        SOUND_EVENTS.register(RaidSounds.DESERT_RAID.getLocation().getPath(), () -> RaidSounds.DESERT_RAID);
        SOUND_EVENTS.register(RaidSounds.DESERT_RAID_WARNING.getLocation().getPath(), () -> RaidSounds.DESERT_RAID_WARNING);
        SOUND_EVENTS.register(MercenarySounds.mercenaryAttack.getLocation().getPath(), () -> MercenarySounds.mercenaryAttack);
        SOUND_EVENTS.register(MercenarySounds.mercenaryCelebrate.getLocation().getPath(), () -> MercenarySounds.mercenaryCelebrate);
        SOUND_EVENTS.register(MercenarySounds.mercenaryDie.getLocation().getPath(), () -> MercenarySounds.mercenaryDie);
        SOUND_EVENTS.register(MercenarySounds.mercenaryHurt.getLocation().getPath(), () -> MercenarySounds.mercenaryHurt);
        SOUND_EVENTS.register(MercenarySounds.mercenarySay.getLocation().getPath(), () -> MercenarySounds.mercenarySay);
        SOUND_EVENTS.register(MercenarySounds.mercenaryStep.getLocation().getPath(), () -> MercenarySounds.mercenaryStep);
    }
}

