/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.inventory.ModContainers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ContainerCrafting
extends AbstractContainerMenu {
    public final CraftingContainer craftMatrix;
    public final ResultContainer craftResult = new ResultContainer();
    private final Slot craftResultSlot;
    private final DataSlot switchableSlot;
    private final DataSlot recipeIndexSlot;
    private final List<ItemStack> remainingItems;
    private final boolean complete;
    private final Level world;
    private final Inventory inv;
    private final BlockPos pos;
    private final int moduleId;

    public static ContainerCrafting fromFriendlyByteBuf(int windowId, Inventory inv, RegistryFriendlyByteBuf packetBuffer) {
        boolean complete = packetBuffer.readBoolean();
        BlockPos tePos = packetBuffer.readBlockPos();
        int moduleId = packetBuffer.readInt();
        return new ContainerCrafting(windowId, inv, complete, tePos, moduleId);
    }

    public ContainerCrafting(int windowId, Inventory inv, boolean complete, BlockPos pos, int moduleId) {
        super((MenuType)ModContainers.craftingGrid.get(), windowId);
        int j;
        int i;
        this.moduleId = moduleId;
        this.world = inv.player.level();
        this.inv = inv;
        this.complete = complete;
        this.pos = pos;
        this.craftMatrix = complete ? new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3) : new TransientCraftingContainer((AbstractContainerMenu)this, 2, 2);
        this.craftResultSlot = this.addSlot((Slot)new ResultSlot(this, inv.player, this.craftMatrix, (Container)this.craftResult, 0, 124, 35){

            public boolean mayPickup(Player playerIn) {
                return false;
            }
        });
        for (i = 0; i < this.craftMatrix.getWidth(); ++i) {
            for (j = 0; j < this.craftMatrix.getHeight(); ++j) {
                this.addSlot(new Slot(this, (Container)this.craftMatrix, j + i * (complete ? 3 : 2), 30 + j * 18, 17 + i * 18){

                    public int getMaxStackSize() {
                        return 1;
                    }

                    @NotNull
                    public ItemStack remove(int par1) {
                        return ItemStack.EMPTY;
                    }

                    public boolean mayPlace(ItemStack par1ItemStack) {
                        return true;
                    }

                    public boolean mayPickup(Player par1PlayerEntity) {
                        return false;
                    }
                });
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inv, i, 8 + i * 18, 142));
        }
        this.switchableSlot = DataSlot.standalone();
        this.recipeIndexSlot = DataSlot.standalone();
        this.addDataSlot(this.switchableSlot);
        this.addDataSlot(this.recipeIndexSlot);
        this.remainingItems = new ArrayList<ItemStack>();
        this.slotsChanged((Container)this.craftMatrix);
    }

    public void slotsChanged(Container inventoryIn) {
        if (!this.world.isClientSide) {
            ServerPlayer player = (ServerPlayer)this.inv.player;
            List<RecipeHolder> recipes = player.server.getRecipeManager().getRecipesFor(RecipeType.CRAFTING, (RecipeInput)this.craftMatrix.asCraftInput(), this.world).stream().filter(recipe -> ((CraftingRecipe)recipe.value()).isSpecial() || !this.world.getGameRules().getBoolean(GameRules.RULE_LIMITED_CRAFTING) || player.getRecipeBook().contains(recipe) || player.isCreative()).toList();
            if (recipes.isEmpty()) {
                this.switchableSlot.set(0);
                this.craftResultSlot.set(ItemStack.EMPTY);
            } else {
                this.switchableSlot.set(recipes.size());
                this.recipeIndexSlot.set(this.recipeIndexSlot.get() % recipes.size());
                ItemStack stack = ((CraftingRecipe)recipes.get(this.recipeIndexSlot.get()).value()).assemble((RecipeInput)this.craftMatrix.asCraftInput(), (HolderLookup.Provider)this.world.registryAccess());
                this.craftResultSlot.set(stack);
            }
        }
        super.slotsChanged(inventoryIn);
    }

    public boolean canSwitchRecipes() {
        return this.switchableSlot.get() > 1;
    }

    public void switchRecipes() {
        this.recipeIndexSlot.set(this.recipeIndexSlot.get() + 1);
        this.slotsChanged((Container)this.craftMatrix);
    }

    public boolean stillValid(@NotNull Player playerIn) {
        return true;
    }

    public void clicked(int slotId, int clickedButton, @NotNull ClickType mode, @NotNull Player playerIn) {
        if (slotId >= 1 && slotId < 5 + (this.complete ? 5 : 0)) {
            if (mode == ClickType.PICKUP || mode == ClickType.PICKUP_ALL || mode == ClickType.SWAP) {
                Slot slot = (Slot)this.slots.get(slotId);
                this.handleSlotClick(slot, this.getCarried());
                return;
            }
            return;
        }
        if (mode == ClickType.QUICK_MOVE) {
            return;
        }
        super.clicked(slotId, clickedButton, mode, playerIn);
    }

    public ItemStack handleSlotClick(Slot slot, ItemStack stack) {
        if (stack.getCount() > 0) {
            ItemStack copy = stack.copy();
            copy.setCount(1);
            slot.set(copy);
        } else if (slot.getItem().getCount() > 0) {
            slot.set(ItemStack.EMPTY);
        }
        return slot.getItem().copy();
    }

    @NotNull
    public ItemStack quickMoveStack(Player playerIn, int index) {
        int total_crafting_slots = 5 + (this.complete ? 5 : 0);
        if (index <= total_crafting_slots) {
            return ItemStack.EMPTY;
        }
        int total_slots = 41 + (this.complete ? 5 : 0);
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(itemstack1, total_crafting_slots, total_slots, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index < 32 ? !this.moveItemStackTo(itemstack1, 32, total_slots, false) : index < total_slots && !this.moveItemStackTo(itemstack1, total_crafting_slots, 32, false) || !this.moveItemStackTo(itemstack1, total_crafting_slots, total_slots, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
        }
        return itemstack;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn != this.craftResultSlot && super.canTakeItemForPickAll(stack, slotIn);
    }

    public Level getWorldObj() {
        return this.world;
    }

    public Player getPlayer() {
        return this.inv.player;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public CraftingContainer getInv() {
        return this.craftMatrix;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public List<ItemStack> getRemainingItems() {
        Optional iRecipe = this.world.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)this.craftMatrix.asCraftInput(), this.world);
        if (iRecipe.isPresent()) {
            NonNullList ri = ((CraftingRecipe)((RecipeHolder)iRecipe.get()).value()).getRemainingItems((RecipeInput)this.craftMatrix.asCraftInput());
            this.remainingItems.clear();
            for (int i = 0; i < ri.size(); ++i) {
                if (((ItemStack)ri.get(i)).isEmpty()) continue;
                this.remainingItems.add((ItemStack)ri.get(i));
            }
        }
        return this.remainingItems;
    }

    public int getModuleId() {
        return this.moduleId;
    }
}

