/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.connections;

import com.minecolonies.api.colony.connections.ConnectionEventType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public record ConnectionEvent(int id, String name, ConnectionEventType connectionEventType) {
    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putInt("id", this.id);
        compoundTag.putString("name", this.name);
        compoundTag.putInt("status", this.connectionEventType.ordinal());
        return compoundTag;
    }

    public void serializeByteBuf(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeUtf(this.name);
        buf.writeInt(this.connectionEventType.ordinal());
    }

    public static ConnectionEvent deserializeNBT(CompoundTag compoundTag) {
        return new ConnectionEvent(compoundTag.getInt("id"), compoundTag.getString("name"), ConnectionEventType.values()[compoundTag.getInt("status")]);
    }

    public static ConnectionEvent deserializeByteBuf(FriendlyByteBuf buf) {
        return new ConnectionEvent(buf.readInt(), buf.readUtf(Short.MAX_VALUE), ConnectionEventType.values()[buf.readInt()]);
    }
}

