/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.claim;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.claim.IChunkClaimData;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class ChunkClaimData
implements IChunkClaimData,
INBTSerializable<CompoundTag> {
    private Set<Integer> colonies = new HashSet<Integer>();
    private int owningColony = 0;
    private final Map<Integer, Set<BlockPos>> claimingBuildings;

    public ChunkClaimData() {
        this(new HashSet<Integer>(), 0, new HashMap<Integer, Set<BlockPos>>());
    }

    private ChunkClaimData(Set<Integer> colonies, int owningColony, Map<Integer, Set<BlockPos>> claimingBuildings) {
        this.colonies = colonies;
        this.owningColony = owningColony;
        this.claimingBuildings = claimingBuildings;
    }

    @Override
    public void addColony(int id, LevelChunk chunk) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(id, (ResourceKey<Level>)chunk.getLevel().dimension());
        if (colony == null) {
            return;
        }
        this.colonies.add(id);
        if (this.owningColony == 0 || IColonyManager.getInstance().getColonyByDimension(this.owningColony, (ResourceKey<Level>)chunk.getLevel().dimension()) == null) {
            colony.addLoadedChunk(ChunkPos.asLong((int)chunk.getPos().x, (int)chunk.getPos().z), chunk);
            this.owningColony = id;
        }
        chunk.setUnsaved(true);
    }

    @Override
    public void removeColony(int id, LevelChunk chunk) {
        this.colonies.remove(id);
        this.claimingBuildings.remove(id);
        if (this.owningColony == id) {
            this.owningColony = !this.claimingBuildings.isEmpty() ? this.claimingBuildings.keySet().iterator().next() : (!this.colonies.isEmpty() ? this.colonies.iterator().next() : 0);
        }
        chunk.setUnsaved(true);
    }

    @Override
    public void setStaticColonyClaim(List<Integer> colonies) {
        this.colonies = new HashSet<Integer>(colonies);
    }

    @Override
    public void reset(LevelChunk chunk) {
        this.colonies.clear();
        this.owningColony = 0;
        this.claimingBuildings.clear();
        chunk.setUnsaved(true);
    }

    @Override
    public void addBuildingClaim(int colonyId, BlockPos pos, LevelChunk chunk) {
        IColony colony;
        if (chunk.getPos().equals((Object)ChunkPos.ZERO) && ((colony = IColonyManager.getInstance().getColonyByDimension(colonyId, (ResourceKey<Level>)chunk.getLevel().dimension())) == null || BlockPosUtil.getDistance2D(colony.getCenter(), BlockPos.ZERO) > 200L)) {
            Log.getLogger().warn("Claiming id:" + colonyId + " building at zero pos!" + String.valueOf(pos), (Throwable)new Exception());
        }
        if (this.owningColony == 0) {
            this.setOwningColony(colonyId, chunk);
            colony = IColonyManager.getInstance().getColonyByDimension(colonyId, (ResourceKey<Level>)chunk.getLevel().dimension());
            if (colony != null) {
                colony.addLoadedChunk(ChunkPos.asLong((int)chunk.getPos().x, (int)chunk.getPos().z), chunk);
            }
        }
        if (this.claimingBuildings.containsKey(colonyId)) {
            this.claimingBuildings.get(colonyId).add(pos);
        } else {
            HashSet<BlockPos> newList = new HashSet<BlockPos>();
            newList.add(pos);
            this.claimingBuildings.put(colonyId, newList);
        }
        chunk.setUnsaved(true);
    }

    @Override
    public void removeBuildingClaim(int colonyId, BlockPos pos, LevelChunk chunk) {
        if (!this.claimingBuildings.containsKey(colonyId)) {
            return;
        }
        chunk.setUnsaved(true);
        Set<BlockPos> buildings = this.claimingBuildings.get(colonyId);
        buildings.remove(pos);
        if (buildings.isEmpty()) {
            this.claimingBuildings.remove(colonyId);
            if (this.owningColony == colonyId && !this.colonies.contains(this.owningColony)) {
                if (this.claimingBuildings.isEmpty()) {
                    this.owningColony = this.colonies.isEmpty() ? 0 : this.colonies.iterator().next();
                } else {
                    Iterator<Map.Entry<Integer, Set<BlockPos>>> colonyIt = this.claimingBuildings.entrySet().iterator();
                    while (colonyIt.hasNext()) {
                        Map.Entry<Integer, Set<BlockPos>> colonyEntry = colonyIt.next();
                        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyEntry.getKey(), (ResourceKey<Level>)chunk.getLevel().dimension());
                        if (colony == null) continue;
                        Iterator<BlockPos> buildingIt = colonyEntry.getValue().iterator();
                        while (buildingIt.hasNext()) {
                            BlockPos buildingPos = buildingIt.next();
                            if (colony.getBuildingManager().getBuilding(buildingPos) != null) {
                                colony.addLoadedChunk(ChunkPos.asLong((int)chunk.getPos().x, (int)chunk.getPos().z), chunk);
                                this.setOwningColony(colonyEntry.getKey(), chunk);
                                return;
                            }
                            buildingIt.remove();
                        }
                        if (!colonyEntry.getValue().isEmpty()) continue;
                        colonyIt.remove();
                    }
                }
            }
        }
    }

    @Override
    public void setOwningColony(int id, LevelChunk chunk) {
        this.owningColony = id;
        chunk.setUnsaved(true);
    }

    @Override
    public int getOwningColony() {
        return this.owningColony;
    }

    @Override
    @NotNull
    public List<Integer> getStaticClaimColonies() {
        return new ArrayList<Integer>(this.colonies);
    }

    @Override
    @NotNull
    public Map<Integer, Set<BlockPos>> getAllClaimingBuildings() {
        return this.claimingBuildings;
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        compound.putInt("id", this.owningColony);
        ListTag colonyClaimTag = new ListTag();
        for (int colonyId : this.colonies) {
            colonyClaimTag.add((Object)IntTag.valueOf((int)colonyId));
        }
        compound.put("colonies", (Tag)colonyClaimTag);
        ListTag buildingsClaimTag = new ListTag();
        for (Map.Entry<Integer, Set<BlockPos>> entry : this.claimingBuildings.entrySet()) {
            CompoundTag perColonyEntry = new CompoundTag();
            perColonyEntry.putInt("id", entry.getKey().intValue());
            ListTag buildingListTag = new ListTag();
            for (BlockPos pos : entry.getValue()) {
                BlockPosUtil.writeToListNBT(buildingListTag, pos);
            }
            perColonyEntry.put("buildingClaim", (Tag)buildingListTag);
            buildingsClaimTag.add((Object)perColonyEntry);
        }
        compound.put("buildingListClaim", (Tag)buildingsClaimTag);
        return compound;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        this.owningColony = compound.getInt("id");
        ListTag colonyClaim = compound.getList("colonies", 3);
        for (int i = 0; i < colonyClaim.size(); ++i) {
            this.colonies.add(colonyClaim.getInt(i));
        }
        ListTag buildingClaim = compound.getList("buildingListClaim", 10);
        for (int i = 0; i < buildingClaim.size(); ++i) {
            CompoundTag perColonyCompound = buildingClaim.getCompound(i);
            int id = perColonyCompound.getInt("id");
            Set buildings = this.claimingBuildings.computeIfAbsent(id, HashSet::new);
            ListTag buildingList = perColonyCompound.getList("buildingClaim", 10);
            for (int j = 0; j < buildingList.size(); ++j) {
                buildings.add(BlockPosUtil.readFromListNBT(buildingList, j));
            }
        }
        if (this.owningColony == 0 && !this.getStaticClaimColonies().isEmpty()) {
            this.owningColony = this.getStaticClaimColonies().get(0);
        }
    }
}

