/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.advancements;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;

public class BuildingAddRecipeTrigger
extends SimpleCriterionTrigger<BuildingAddRecipeTriggerInstance> {
    public void trigger(ServerPlayer player, IRecipeStorage recipeStorage) {
        this.trigger(player, trigger -> trigger.test(recipeStorage));
    }

    public Codec<BuildingAddRecipeTriggerInstance> codec() {
        return BuildingAddRecipeTriggerInstance.CODEC;
    }

    public record BuildingAddRecipeTriggerInstance(Optional<ContextAwarePredicate> player, List<ItemPredicate> outputItemPredicates, int craftingSize) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final int DEFAULT_CRAFTING_SIZE = -1;
        public static final List<ItemPredicate> DEFAULT_OUTPUT_ITEM_PREDICATES = Collections.emptyList();
        public static final Codec<BuildingAddRecipeTriggerInstance> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(BuildingAddRecipeTriggerInstance::player), (App)ItemPredicate.CODEC.listOf().optionalFieldOf("items", DEFAULT_OUTPUT_ITEM_PREDICATES).forGetter(BuildingAddRecipeTriggerInstance::outputItemPredicates), (App)ExtraCodecs.intRange((int)0, (int)10).optionalFieldOf("crafting_size", (Object)-1).forGetter(BuildingAddRecipeTriggerInstance::craftingSize)).apply((Applicative)builder, BuildingAddRecipeTriggerInstance::new));

        public static Criterion<BuildingAddRecipeTriggerInstance> buildingAddRecipe() {
            return BuildingAddRecipeTriggerInstance.buildingAddRecipe(DEFAULT_OUTPUT_ITEM_PREDICATES, -1);
        }

        public static Criterion<BuildingAddRecipeTriggerInstance> buildingAddRecipe(List<ItemPredicate> outputItemPredicates) {
            return BuildingAddRecipeTriggerInstance.buildingAddRecipe(outputItemPredicates, -1);
        }

        public static Criterion<BuildingAddRecipeTriggerInstance> buildingAddRecipe(List<ItemPredicate> outputItemPredicates, int craftingSize) {
            return ((BuildingAddRecipeTrigger)((Object)AdvancementTriggers.BUILDING_ADD_RECIPE.get())).createCriterion((CriterionTriggerInstance)new BuildingAddRecipeTriggerInstance(Optional.empty(), outputItemPredicates, craftingSize));
        }

        public boolean test(IRecipeStorage recipeStorage) {
            if (!this.outputItemPredicates.isEmpty()) {
                boolean outputMatches = false;
                for (ItemPredicate itemPredicate : this.outputItemPredicates) {
                    if (!itemPredicate.test(recipeStorage.getPrimaryOutput())) continue;
                    outputMatches = true;
                    break;
                }
                if (this.craftingSize != -1) {
                    return outputMatches && this.craftingSize == recipeStorage.getGridSize();
                }
                return outputMatches;
            }
            return true;
        }
    }
}

