/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.common.container;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

abstract class AbstractContainer
extends AbstractContainerMenu {
    protected AbstractContainer(@Nullable MenuType<?> type, int id) {
        super(type, id);
    }

    @Nonnull
    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack returnStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            int upgradeSlotCount;
            ItemStack slotStack = slot.getItem();
            returnStack = slotStack.copy();
            int containerSlots = this.slots.size() - player.getInventory().items.size();
            if (index < containerSlots ? !this.moveItemStackTo(slotStack, containerSlots, this.slots.size(), false) : !this.moveItemStackTo(slotStack, 0, containerSlots - (upgradeSlotCount = 0), false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == returnStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return returnStack;
    }

    protected int addSlotRange(Container handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot(new Slot(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    protected void addSlotBox(Container handler, int startIndex, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            startIndex = this.addSlotRange(handler, startIndex, x, y, horAmount, dx);
            y += dy;
        }
    }

    protected void layoutPlayerInventorySlots(Inventory inventory, int startIndex, int leftCol, int topRow) {
        this.addSlotBox((Container)inventory, startIndex + 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange((Container)inventory, startIndex, leftCol, topRow += 58, 9, 18);
    }
}

