/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import cy.jdkdigital.generatorgalore.Config;
import cy.jdkdigital.generatorgalore.common.conditions.GeneratorExistsCondition;
import cy.jdkdigital.generatorgalore.common.datamap.FluidFuelMap;
import cy.jdkdigital.generatorgalore.common.datamap.PotionComponentIngredient;
import cy.jdkdigital.generatorgalore.common.datamap.SolidFuelMap;
import cy.jdkdigital.generatorgalore.registry.GeneratorRegistry;
import cy.jdkdigital.generatorgalore.util.GeneratorUtil;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import org.slf4j.Logger;

@Mod(value="generatorgalore")
public class GeneratorGalore {
    public static final String MODID = "generatorgalore";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"generatorgalore");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"generatorgalore");
    public static final DeferredRegister<MenuType<?>> CONTAINER_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"generatorgalore");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"generatorgalore");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"generatorgalore");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"generatorgalore");
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)"generatorgalore");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"generatorgalore");
    public static final DeferredRegister<MapCodec<? extends ICondition>> CONDITION_CODECS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.CONDITION_CODECS, (String)"generatorgalore");
    public static final DeferredRegister<IngredientType<?>> INGREDIENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.INGREDIENT_TYPES, (String)"generatorgalore");
    public static DeferredHolder<CreativeModeTab, CreativeModeTab> TAB = CREATIVE_MODE_TABS.register("generatorgalore", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).icon(() -> new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"iron_generator")))).title((Component)Component.literal((String)"Generator Galore")).build());
    public static final DeferredHolder<MapCodec<? extends ICondition>, MapCodec<GeneratorExistsCondition>> GENERATOR_EXISTS_CONDITION = CONDITION_CODECS.register("generator_exists", () -> GeneratorExistsCondition.CODEC);
    public static final DataMapType<Block, FluidFuelMap> FLUID_FUEL_MAP = DataMapType.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"generatorgalore", (String)"fluid_fuel_map"), (ResourceKey)Registries.BLOCK, FluidFuelMap.CODEC).synced(FluidFuelMap.CODEC, false).build();
    public static final DataMapType<Block, SolidFuelMap> SOLID_FUEL_MAP = DataMapType.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"generatorgalore", (String)"solid_fuel_map"), (ResourceKey)Registries.BLOCK, SolidFuelMap.CODEC).synced(SolidFuelMap.CODEC, false).build();
    public static final DeferredHolder<IngredientType<?>, IngredientType<PotionComponentIngredient>> POTIOM_INGREDIENT_TYPE = INGREDIENT_TYPES.register("component", () -> new IngredientType(PotionComponentIngredient.CODEC));

    public GeneratorGalore(IEventBus modEventBus, ModContainer modContainer) {
        GeneratorRegistry.discoverGenerators();
        BLOCKS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        CONTAINER_TYPES.register(modEventBus);
        ITEMS.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        RECIPE_TYPES.register(modEventBus);
        PARTICLE_TYPES.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        CONDITION_CODECS.register(modEventBus);
        INGREDIENT_TYPES.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_CONFIG);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_CONFIG);
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="generatorgalore")
    public static class EventHandler {
        @SubscribeEvent
        public static void buildContents(BuildCreativeModeTabContentsEvent event) {
            if (event.getTab().equals(TAB.get())) {
                for (DeferredHolder item : ITEMS.getEntries()) {
                    event.accept((ItemLike)item.get());
                }
            }
        }

        @SubscribeEvent
        private static void registerDataMap(RegisterDataMapTypesEvent event) {
            event.register(FLUID_FUEL_MAP);
            event.register(SOLID_FUEL_MAP);
        }

        @SubscribeEvent
        public static void registerCapabilities(RegisterCapabilitiesEvent event) {
            GeneratorRegistry.generators.values().forEach(generatorObject -> {
                event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, generatorObject.getBlockEntityType().get(), (myBlockEntity, side) -> myBlockEntity.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID) ? null : myBlockEntity.inventoryHandler);
                event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, generatorObject.getBlockEntityType().get(), (myBlockEntity, side) -> myBlockEntity.energyHandler);
                event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, generatorObject.getBlockEntityType().get(), (myBlockEntity, side) -> myBlockEntity.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID) ? myBlockEntity.fluidInventory : null);
            });
        }
    }
}

